/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.config;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.UtilDefinition;
import dev.schmarrn.lighty.config.BooleanConfig;
import dev.schmarrn.lighty.config.ColorConfig;
import dev.schmarrn.lighty.config.ConfigSerDe;
import dev.schmarrn.lighty.config.IntegerConfig;
import dev.schmarrn.lighty.config.ResourceLocationConfig;
import dev.schmarrn.lighty.config.ResourceLocationListConfig;
import dev.schmarrn.lighty.config.compat.Lighty2Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2960;

public class Config {
    private static final String PATH = UtilDefinition.INSTANCE.getConfigDir().toString() + "/lighty/base.config";
    private static final Map<String, String> fileState = new HashMap<String, String>();
    private static final Map<String, ConfigSerDe> configValues = new HashMap<String, ConfigSerDe>();
    private static boolean initStage = true;
    public static final ResourceLocationConfig LAST_USED_RENDERER = new ResourceLocationConfig("lighty.last_used_renderer", class_2960.method_60654((String)"lighty:renderer_carpet"));
    public static final ResourceLocationListConfig ACTIVE_DATA_PROVIDERS = new ResourceLocationListConfig("lighty.active_data_providers", Config.stringToRL("lighty:data_provider_base", "lighty:data_provider_farmland"));
    public static final IntegerConfig SKY_THRESHOLD = new IntegerConfig("lighty.sky_threshold", 0, 0, 15);
    public static final IntegerConfig BLOCK_THRESHOLD = new IntegerConfig("lighty.block_threshold", 0, 0, 15);
    public static final IntegerConfig OVERLAY_DISTANCE = new IntegerConfig("lighty.overlay_distance", 2, 1, 32);
    public static final IntegerConfig OVERLAY_BRIGHTNESS = new IntegerConfig("lighty.overlay_brightness", 10, 0, 15);
    public static final IntegerConfig FARM_GROWTH_THRESHOLD = new IntegerConfig("lighty.farm_growth_threshold", 8, 0, 15);
    public static final IntegerConfig FARM_UPROOT_THRESHOLD = new IntegerConfig("lighty.farm_uproot_threshold", 8, 0, 15);
    public static final BooleanConfig SHOW_SAFE = new BooleanConfig("lighty.show_safe", true);
    public static final IntegerConfig CHUNKS_PER_TICK = new IntegerConfig("lighty.chunks_per_tick", 4, 1, 1024);
    public static final ColorConfig OVERLAY_GREEN = new ColorConfig("lighty.overlay_green", 65280);
    public static final ColorConfig OVERLAY_ORANGE = new ColorConfig("lighty.overlay_orange", 0xFF6600);
    public static final ColorConfig OVERLAY_RED = new ColorConfig("lighty.overlay_red", 0xFF0000);
    public static final ColorConfig ADDITIONAL_OVERLAY_GOOD = new ColorConfig("lighty.additional_overlay_good", 65280);
    public static final ColorConfig ADDITIONAL_OVERLAY_WARN = new ColorConfig("lighty.additional_overlay_warn", 0xFF6600);
    public static final ColorConfig ADDITIONAL_OVERLAY_BAD = new ColorConfig("lighty.additional_overlay_bad", 0xFF0000);
    public static final ResourceLocationListConfig AUTO_ON_ITEM_LIST = new ResourceLocationListConfig("lighty.auto_on.item", Config.stringToRL("minecraft:torch", "minecraft:soul_torch", "minecraft:lantern", "minecraft:soul_lantern"));
    public static final BooleanConfig SHOULD_AUTO_ON = new BooleanConfig("lighty.auto_on", false);
    public static final BooleanConfig SHOW_SKYLIGHT_LEVEL = new BooleanConfig("lighty.show_skylight_level", true);
    public static final ResourceLocationConfig CARPET_TEXTURE = new ResourceLocationConfig("lighty.mode.carpet.texture", class_2960.method_60655((String)"lighty", (String)"textures/block/transparent.png"));
    public static final ResourceLocationConfig CROSS_TEXTURE = new ResourceLocationConfig("lighty.mode.cross.texture", class_2960.method_60655((String)"lighty", (String)"textures/block/cross.png"));

    private static List<class_2960> stringToRL(String ... stuff) {
        return Arrays.stream(stuff).map(class_2960::method_60654).toList();
    }

    private static void loadFromFile(String key, ConfigSerDe type) {
        String value = fileState.getOrDefault(key, null);
        if (value != null) {
            type.deserialize(value);
        }
    }

    public static void register(String key, ConfigSerDe type) {
        configValues.put(key, type);
        Config.loadFromFile(key, type);
    }

    public static void reloadFromDisk() {
        File file = new File(PATH);
        try {
            BufferedReader bf = new BufferedReader(new FileReader(file));
            AtomicInteger lineNumber = new AtomicInteger(0);
            bf.lines().forEach(line -> {
                int ln = lineNumber.incrementAndGet();
                String[] splits = line.split("=");
                if (splits.length == 2) {
                    fileState.putIfAbsent(splits[0].trim(), splits[1].trim());
                } else {
                    Lighty.LOGGER.warn("Too many = signs on line {}. Removing \"{}\" from config.", (Object)ln, line);
                }
            });
            bf.close();
        }
        catch (FileNotFoundException e) {
            Lighty.LOGGER.warn("No Lighty config found at {}, using defaults.", (Object)PATH);
        }
        catch (IOException e) {
            Lighty.LOGGER.error("Could not close Lighty config at {}. This should not happen, please report on GitHub. Abort. {}", (Object)PATH, (Object)e);
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, ConfigSerDe> entry : configValues.entrySet()) {
            Config.loadFromFile(entry.getKey(), entry.getValue());
        }
    }

    public static void save() {
        if (initStage) {
            return;
        }
        StringBuilder content = new StringBuilder();
        for (Map.Entry<String, ConfigSerDe> pair : configValues.entrySet()) {
            content.append(pair.getKey()).append("=").append(pair.getValue().serialize()).append("\n");
        }
        File file = new File(PATH);
        file.getParentFile().mkdirs();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(content.toString());
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            Lighty.LOGGER.warn("Could not write Lighty config file at {}. Config changes are not saved. {}", (Object)PATH, (Object)e);
        }
    }

    public static void init() {
        if (Lighty2Config.exists()) {
            Lighty2Config.migrate();
        } else {
            Config.reloadFromDisk();
        }
        initStage = false;
        Config.save();
    }
}

