/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.schmarrn.lighty.Lighty;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import net.minecraft.class_10896;
import net.minecraft.class_2960;
import net.minecraft.class_9801;

public class BufferHolder
implements AutoCloseable {
    private final Object2ObjectOpenHashMap<class_2960, class_10896> overlayBuffers = new Object2ObjectOpenHashMap();
    private final Object2BooleanMap<class_2960> isValid = new Object2BooleanOpenHashMap();
    private static final int BUFFER_TYPE_VERTEX = 40;
    private static final int BUFFER_TYPE_INDEX = 72;

    boolean isValid(class_2960 key) {
        return this.isValid.getOrDefault((Object)key, false);
    }

    public void invalidateBuffer(class_2960 key) {
        this.isValid.put((Object)key, false);
    }

    @Override
    public void close() {
        this.overlayBuffers.values().forEach(class_10896::close);
        this.overlayBuffers.clear();
    }

    void upload(class_9801 data, class_2960 dataProviderKey) {
        if (data == null) {
            this.isValid.put((Object)dataProviderKey, false);
            return;
        }
        class_10896 previous = (class_10896)this.overlayBuffers.get((Object)dataProviderKey);
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder commandEncoder = device.createCommandEncoder();
        if (previous != null) {
            if (previous.method_68540().size() < data.method_60818().remaining()) {
                previous.method_68540().close();
                previous.method_68545(device.createBuffer(() -> "Lighty vertex buffer for " + String.valueOf(dataProviderKey), 40, data.method_60818()));
            } else if (!previous.method_68540().isClosed()) {
                commandEncoder.writeToBuffer(previous.method_68540().slice(), data.method_60818());
            } else {
                Lighty.LOGGER.info("I am curious whether this will ever trigger (BufferHolder::upload)");
            }
            ByteBuffer indexBuffer = data.method_60821();
            if (indexBuffer != null) {
                if (previous.method_68544() != null && previous.method_68544().size() >= indexBuffer.remaining()) {
                    if (!previous.method_68544().isClosed()) {
                        commandEncoder.writeToBuffer(previous.method_68544().slice(), indexBuffer);
                    }
                } else {
                    if (previous.method_68544() != null) {
                        previous.method_68544().close();
                    }
                    previous.method_68542(device.createBuffer(() -> "Lighty index buffer for" + String.valueOf(dataProviderKey), 72, indexBuffer));
                }
            } else if (previous.method_68544() != null) {
                previous.method_68544().close();
                previous.method_68542(null);
            }
            previous.method_68541(data.method_60822().comp_751());
            previous.method_68543(indexBuffer != null ? data.method_60822().comp_753() : null);
        } else {
            GpuBuffer vertexBuffer = device.createBuffer(() -> "Lighty vertex buffer for " + String.valueOf(dataProviderKey), 40, data.method_60818());
            ByteBuffer indexBuffer = data.method_60821();
            GpuBuffer gpuIndexBuffer = indexBuffer != null ? device.createBuffer(() -> "Lighty index buffer for" + String.valueOf(dataProviderKey), 72, indexBuffer) : null;
            this.overlayBuffers.put((Object)dataProviderKey, (Object)new class_10896(vertexBuffer, gpuIndexBuffer, data.method_60822().comp_751(), gpuIndexBuffer != null ? data.method_60822().comp_753() : null));
        }
        data.close();
        this.isValid.put((Object)dataProviderKey, true);
    }

    Object2ObjectOpenHashMap<class_2960, class_10896> getGpuBuffers() {
        return this.overlayBuffers;
    }
}

