/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.Compute;
import dev.schmarrn.lighty.core.LightyPipelines;
import dev.schmarrn.lighty.core.RendererRegistry;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_846;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class LightyRenderer {
    private static final Vector4f UNIT_COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Matrix4f DEFAULT_TEXTURE_MATRIX = new Matrix4f();

    private static int addData(class_4076 chunkSection, class_10896 gpuBuffer, class_243 camPos, int biggestBufferSize, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, List<class_11282.class_11283> transforms) {
        class_243 origin = new class_243((class_2382)chunkSection.method_19767());
        class_243 dPos = origin.method_1020(camPos);
        if (gpuBuffer.method_68544() == null && gpuBuffer.method_68546() > biggestBufferSize) {
            biggestBufferSize = gpuBuffer.method_68546();
        }
        int currentTransformationIndex = transforms.size();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        modelViewMatrix.translate((float)dPos.method_10216(), (float)dPos.method_10214(), (float)dPos.method_10215());
        transforms.add(new class_11282.class_11283((Matrix4fc)modelViewMatrix, (Vector4fc)UNIT_COLOR_MODULATOR, (Vector3fc)new Vector3f(), (Matrix4fc)DEFAULT_TEXTURE_MATRIX, 1.0f));
        drawList.add((RenderPass.class_10884<GpuBufferSlice[]>)new RenderPass.class_10884(0, gpuBuffer.method_68540(), gpuBuffer.method_68544(), gpuBuffer.method_68547(), 0, gpuBuffer.method_68546(), (bufferSlice, uniformUploader) -> uniformUploader.upload("DynamicTransforms", bufferSlice[currentTransformationIndex])));
        return biggestBufferSize;
    }

    private static int goThroughEachBuffer(class_310 minecraft, class_4184 camera, class_243 camPos, class_4604 frustum, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, List<class_11282.class_11283> transforms) {
        int biggestBufferSize = 0;
        ObjectIterator cacheIterator = Compute.cachedBuffers.object2ObjectEntrySet().fastIterator();
        while (cacheIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
            class_4076 chunkSection = (class_4076)entry.getKey();
            BufferHolder cachedBuffer = (BufferHolder)entry.getValue();
            Object2ObjectOpenHashMap<class_2960, class_10896> gpuBuffers = cachedBuffer.getGpuBuffers();
            ObjectIterator bufferIterator = gpuBuffers.object2ObjectEntrySet().fastIterator();
            while (bufferIterator.hasNext()) {
                class_2338 sectionOrigin;
                class_238 chunkBoundaries;
                Object2ObjectMap.Entry bufferEntry = (Object2ObjectMap.Entry)bufferIterator.next();
                if (!cachedBuffer.isValid((class_2960)bufferEntry.getKey()) || !frustum.method_23093(chunkBoundaries = class_238.method_54784((class_2338)(sectionOrigin = chunkSection.method_19767()).method_10069(-1, -1, -1), (class_2338)sectionOrigin.method_10069(16, 16, 16)))) continue;
                biggestBufferSize = LightyRenderer.addData(chunkSection, (class_10896)bufferEntry.getValue(), camPos, biggestBufferSize, drawList, transforms);
            }
        }
        return biggestBufferSize;
    }

    private static int goThroughEachSection(class_310 minecraft, class_4184 camera, class_243 camPos, class_4604 frustum, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, List<class_11282.class_11283> transforms) {
        class_1923 cameraChunkPos = new class_1923(camera.method_19328());
        int biggestBufferSize = 0;
        for (int xx = -Compute.computationDistance + 1; xx < Compute.computationDistance; ++xx) {
            for (int zz = -Compute.computationDistance + 1; zz < Compute.computationDistance; ++zz) {
                class_1923 chunkPos = new class_1923(cameraChunkPos.field_9181 + xx, cameraChunkPos.field_9180 + zz);
                for (int ii = 0; ii < minecraft.field_1687.method_32890(); ++ii) {
                    class_4076 chunkSection = class_4076.method_18681((class_1923)chunkPos, (int)(ii + minecraft.field_1687.method_32891()));
                    BufferHolder cachedBuffer = (BufferHolder)Compute.cachedBuffers.get((Object)chunkSection);
                    if (cachedBuffer == null) continue;
                    for (Map.Entry entry : cachedBuffer.getGpuBuffers().entrySet()) {
                        class_2960 key = (class_2960)entry.getKey();
                        if (!cachedBuffer.isValid(key) || !frustum.method_23093(class_238.method_54784((class_2338)chunkSection.method_19767().method_10069(-1, -1, -1), (class_2338)chunkSection.method_19767().method_10069(16, 16, 16)))) continue;
                        biggestBufferSize = LightyRenderer.addData(chunkSection, (class_10896)entry.getValue(), camPos, biggestBufferSize, drawList, transforms);
                    }
                }
            }
        }
        return biggestBufferSize;
    }

    private static int goThroughVisibleSections(class_310 minecraft, class_4184 camera, class_243 camPos, class_4604 frustum, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, List<class_11282.class_11283> transforms) {
        int biggestBufferSize = 0;
        for (class_846.class_851 section : minecraft.field_1769.method_62220()) {
            class_4076 sectionPos = class_4076.method_18677((long)section.method_62975());
            BufferHolder cachedBuffer = (BufferHolder)Compute.cachedBuffers.get((Object)sectionPos);
            if (cachedBuffer == null) continue;
            for (Map.Entry entry : cachedBuffer.getGpuBuffers().entrySet()) {
                class_2960 key = (class_2960)entry.getKey();
                if (!cachedBuffer.isValid(key)) continue;
                biggestBufferSize = LightyRenderer.addData(sectionPos, (class_10896)entry.getValue(), camPos, biggestBufferSize, drawList, transforms);
            }
        }
        return biggestBufferSize;
    }

    private static Data prepareData(class_310 minecraft, class_4604 frustum) {
        class_4184 camera = minecraft.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        ArrayList<RenderPass.class_10884<GpuBufferSlice[]>> drawList = new ArrayList<RenderPass.class_10884<GpuBufferSlice[]>>();
        ArrayList<class_11282.class_11283> transforms = new ArrayList<class_11282.class_11283>();
        int biggestBufferSize = LightyRenderer.goThroughEachBuffer(minecraft, camera, camPos, frustum, drawList, transforms);
        GpuBufferSlice[] dynamicTransforms = RenderSystem.getDynamicUniforms().method_71107(transforms.toArray(new class_11282.class_11283[0]));
        return new Data(drawList, biggestBufferSize, dynamicTransforms);
    }

    public static void render(class_4604 frustum) {
        if (!SMACH.isEnabled()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        OverlayRenderer renderer = RendererRegistry.getRenderer();
        Data data = LightyRenderer.prepareData(minecraft, frustum);
        GpuDevice device = RenderSystem.getDevice();
        GpuTextureView tex = minecraft.method_1531().method_4619(renderer.getTextureLocation()).method_71659();
        RenderPipeline pipeline = renderer.getPipeline();
        class_276 renderTarget = minecraft.method_1522();
        RenderSystem.class_5590 asib = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer baseIndexBuffer = data.maxIndicesRequired == 0 ? null : asib.method_68274(data.maxIndicesRequired);
        VertexFormat.class_5595 baseIndexType = data.maxIndicesRequired == 0 ? null : asib.method_31924();
        try (RenderPass pass = device.createCommandEncoder().createRenderPass(() -> "Lighty Render Pass for" + String.valueOf(pipeline.getLocation()), renderTarget.method_71639(), OptionalInt.empty(), renderTarget.method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.bindSampler("Sampler2", minecraft.field_1773.method_22974().method_71650());
            pass.setPipeline(pipeline);
            pass.bindSampler("Sampler0", tex);
            pass.drawMultipleIndexed(pipeline == LightyPipelines.TERRAIN_TRANSLUCENT ? data.drawList.reversed() : data.drawList, baseIndexBuffer, baseIndexType, List.of("DynamicTransforms"), (Object)data.dynamicTransforms);
        }
    }

    private record Data(List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, int maxIndicesRequired, GpuBufferSlice[] dynamicTransforms) {
    }
}

