/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.text.components;

import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import com.viaversion.viaversion.libs.mcstructs.text.font.AtlasSpriteFont;
import com.viaversion.viaversion.libs.mcstructs.text.font.FontDescription;
import lombok.Generated;

public class ObjectComponent
extends TextComponent {
    private ObjectInfo objectInfo;

    @Override
    public String asSingleString() {
        return this.objectInfo.getDescription();
    }

    @Override
    public TextComponent copy() {
        return new ObjectComponent(this.objectInfo);
    }

    @Override
    public String toString() {
        return ToString.of(this).add("siblings", this.getSiblings(), siblings -> !siblings.isEmpty()).add("style", this.getStyle(), style -> !style.isEmpty()).add("objectInfo", this.objectInfo).toString();
    }

    @Generated
    public ObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    @Generated
    public void setObjectInfo(ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    @Generated
    public ObjectComponent(ObjectInfo objectInfo) {
        this.objectInfo = objectInfo;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectComponent)) {
            return false;
        }
        ObjectComponent other = (ObjectComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectInfo this$objectInfo = this.getObjectInfo();
        ObjectInfo other$objectInfo = other.getObjectInfo();
        return !(this$objectInfo == null ? other$objectInfo != null : !this$objectInfo.equals(other$objectInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObjectComponent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ObjectInfo $objectInfo = this.getObjectInfo();
        result = result * 59 + ($objectInfo == null ? 43 : $objectInfo.hashCode());
        return result;
    }

    public static class AtlasSprite
    implements ObjectInfo {
        public static final Identifier DEFAULT_ATLAS = Identifier.defaultNamespace("blocks");
        private Identifier atlas;
        private Identifier sprite;

        public AtlasSprite(Identifier sprite) {
            this.atlas = DEFAULT_ATLAS;
            this.sprite = sprite;
        }

        @Override
        public FontDescription getUpdatedFont() {
            return new AtlasSpriteFont(this.atlas, this.sprite);
        }

        @Override
        public String getDescription() {
            String shortSprite = Identifier.stripDefaultNamespace(this.sprite);
            if (this.atlas.equals(DEFAULT_ATLAS)) {
                return "[" + shortSprite + "]";
            }
            String shortAtlas = Identifier.stripDefaultNamespace(this.atlas);
            return "[" + shortAtlas + "@" + shortSprite + "]";
        }

        @Override
        public String toString() {
            return ToString.of(this).add("atlas", this.atlas).add("sprite", this.sprite).toString();
        }

        @Generated
        public Identifier getAtlas() {
            return this.atlas;
        }

        @Generated
        public Identifier getSprite() {
            return this.sprite;
        }

        @Generated
        public void setAtlas(Identifier atlas) {
            this.atlas = atlas;
        }

        @Generated
        public void setSprite(Identifier sprite) {
            this.sprite = sprite;
        }

        @Generated
        public AtlasSprite(Identifier atlas, Identifier sprite) {
            this.atlas = atlas;
            this.sprite = sprite;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AtlasSprite)) {
                return false;
            }
            AtlasSprite other = (AtlasSprite)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Identifier this$atlas = this.getAtlas();
            Identifier other$atlas = other.getAtlas();
            if (this$atlas == null ? other$atlas != null : !((Object)this$atlas).equals(other$atlas)) {
                return false;
            }
            Identifier this$sprite = this.getSprite();
            Identifier other$sprite = other.getSprite();
            return !(this$sprite == null ? other$sprite != null : !((Object)this$sprite).equals(other$sprite));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AtlasSprite;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Identifier $atlas = this.getAtlas();
            result = result * 59 + ($atlas == null ? 43 : ((Object)$atlas).hashCode());
            Identifier $sprite = this.getSprite();
            result = result * 59 + ($sprite == null ? 43 : ((Object)$sprite).hashCode());
            return result;
        }
    }

    public static interface ObjectInfo {
        public FontDescription getUpdatedFont();

        public String getDescription();

        public String toString();
    }
}

