/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix;

import b100.fullscreenfix.FullscreenMode;
import b100.fullscreenfix.Global;
import b100.fullscreenfix.VideoMode;
import b100.fullscreenfix.mixin.access.WindowAccess;
import b100.fullscreenfix.util.ConfigUtil;
import com.mojang.serialization.Codec;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1076;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3298;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_7172;

@Environment(value=EnvType.CLIENT)
public class FullscreenFix {
    private static class_1041 window;
    public static boolean windowNeedsUpdate;
    public static boolean fullscreenModeWasChanged;
    private static boolean enableModNextLaunch;
    private static boolean borderlessFullscreen;
    private static boolean fullscreenOptimizations;
    private static boolean autoMinimize;
    private static boolean startInFullscreen;
    private static boolean replaceVideoSettingsButton;
    private static VideoMode fullscreenVideoMode;
    private static final Map<String, String> translations;
    public static class_7172<Integer> fullscreenOption;

    public static boolean isModEnabledNextLaunch() {
        return enableModNextLaunch;
    }

    public static void setModEnabled(boolean value) {
        enableModNextLaunch = value;
    }

    public static boolean isBorderlessEnabled() {
        return borderlessFullscreen;
    }

    public static void setBorderless(boolean value) {
        if (value != borderlessFullscreen) {
            borderlessFullscreen = value;
            FullscreenFix.updateWindow();
        }
    }

    public static boolean isWindowsFullscreenOptimizationsEnabled() {
        return fullscreenOptimizations;
    }

    public static void setWindowsFullscreenOptimizations(boolean value) {
        if (value != fullscreenOptimizations) {
            fullscreenOptimizations = value;
            FullscreenFix.updateWindow();
        }
    }

    public static boolean isFullscreenEnabled() {
        if (window == null) {
            return false;
        }
        return window.method_4498();
    }

    public static void setFullscreen(boolean value) {
        WindowAccess access = (WindowAccess)window;
        access.setFullscreen(value);
        class_7172<Boolean> fullscreenOption = FullscreenFix.getVanillaFullscreenOption();
        if (fullscreenOption != null) {
            fullscreenOption.method_41748((Object)value);
        }
    }

    public static VideoMode getFullscreenVideoMode() {
        return fullscreenVideoMode;
    }

    public static void setFullscreenVideoMode(VideoMode value) {
        if (!VideoMode.compare(fullscreenVideoMode, value)) {
            fullscreenVideoMode = value;
            FullscreenFix.updateWindow();
        }
    }

    public static boolean isAutoMinimizeEnabled() {
        return autoMinimize;
    }

    public static void setAutoMinimize(boolean value) {
        if (autoMinimize != value) {
            autoMinimize = value;
            FullscreenFix.updateWindow();
        }
    }

    public static boolean isStartInFullscreenEnabled() {
        return startInFullscreen;
    }

    public static void setStartInFullscreen(boolean value) {
        startInFullscreen = value;
    }

    public static void setReplaceVideoSettingsButton(boolean value) {
        replaceVideoSettingsButton = value;
    }

    public static boolean shouldReplaceVideoSettingsButton() {
        return replaceVideoSettingsButton;
    }

    public static void updateWindow() {
        windowNeedsUpdate = true;
    }

    public static void setWindow(class_1041 window) {
        FullscreenFix.window = window;
    }

    private static class_7172<Integer> createFullscreenOption() {
        return new class_7172("fullscreenoverride", class_7172.method_42399(), (text, value) -> class_2561.method_30163((String)"idkwhatthisdoes"), (class_7172.class_7178)new class_7172.class_7178<Integer>(){

            public Function<class_7172<Integer>, class_339> method_41756(class_7172.class_7277<Integer> tooltipFactory, class_315 gameOptions, int x, int y, int width, Consumer<Integer> changeCallback) {
                return option -> {
                    class_4185 button = class_4185.method_46430((class_2561)FullscreenFix.getFullscreenModeDisplayText(), pressedButton -> {
                        FullscreenFix.setFullscreenMode(FullscreenFix.getCurrentFullscreenMode().next());
                        pressedButton.method_25355(FullscreenFix.getFullscreenModeDisplayText());
                    }).method_46431();
                    return button;
                };
            }

            public Optional<Integer> validate(Integer value) {
                return Optional.of(class_3532.method_15340((int)value, (int)0, (int)2));
            }

            public Codec<Integer> comp_675() {
                return Codec.INT;
            }
        }, (Object)0, newValue -> {});
    }

    private static class_2561 getFullscreenModeDisplayText() {
        FullscreenMode mode = FullscreenFix.getCurrentFullscreenMode();
        StringBuilder str = new StringBuilder();
        str.append(FullscreenFix.translateToString("option.fullscreen")).append(": ");
        if (mode == FullscreenMode.BORDERLESS) {
            str.append(FullscreenFix.translateToString("option.fullscreen.borderless"));
        } else if (mode == FullscreenMode.ON) {
            str.append(FullscreenFix.translateToString("option.fullscreen.on"));
        } else {
            str.append(FullscreenFix.translateToString("option.fullscreen.off"));
        }
        return class_2561.method_30163((String)str.toString());
    }

    public static FullscreenMode getCurrentFullscreenMode() {
        if (FullscreenFix.isFullscreenEnabled()) {
            if (FullscreenFix.isBorderlessEnabled()) {
                return FullscreenMode.BORDERLESS;
            }
            return FullscreenMode.ON;
        }
        return FullscreenMode.OFF;
    }

    public static void setFullscreenMode(FullscreenMode mode) {
        if (mode == FullscreenMode.OFF) {
            FullscreenFix.setFullscreen(false);
        } else {
            FullscreenFix.setFullscreen(true);
            if (mode == FullscreenMode.BORDERLESS) {
                FullscreenFix.setBorderless(true);
            } else {
                FullscreenFix.setBorderless(false);
            }
        }
        fullscreenModeWasChanged = true;
    }

    public static class_7172<Boolean> getVanillaFullscreenOption() {
        try {
            return class_310.method_1551().field_1690.method_42447();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void loadConfig() {
        ConfigUtil.loadConfig(Global.CONFIG_FILE, (key, value) -> FullscreenFix.parse(key, value), ':');
    }

    public static void saveConfig() {
        StringBuilder str = new StringBuilder();
        str.append("enableMod:" + enableModNextLaunch + "\n");
        str.append("borderlessFullscreen:" + borderlessFullscreen + "\n");
        str.append("fullscreenOptimizations:" + fullscreenOptimizations + "\n");
        str.append("autoMinimize:" + autoMinimize + "\n");
        str.append("startInFullscreen:" + startInFullscreen + "\n");
        if (fullscreenVideoMode != null) {
            str.append("fullscreenMode:" + fullscreenVideoMode.toConfigString() + "\n");
        }
        str.append("replaceVideoSettingsButton:" + replaceVideoSettingsButton + "\n");
        ConfigUtil.saveStringToFile(str.toString(), Global.CONFIG_FILE);
    }

    public static void parse(String key, String value) {
        if (key.equals("borderlessFullscreen")) {
            borderlessFullscreen = value.equalsIgnoreCase("true");
        } else if (key.equals("fullscreenOptimizations")) {
            fullscreenOptimizations = value.equalsIgnoreCase("true");
        } else if (key.equals("autoMinimize")) {
            autoMinimize = value.equalsIgnoreCase("true");
        } else if (key.equals("startInFullscreen")) {
            startInFullscreen = value.equalsIgnoreCase("true");
        } else if (key.equals("fullscreenMode")) {
            fullscreenVideoMode = VideoMode.parse(value);
        } else if (key.equals("replaceVideoSettingsButton")) {
            replaceVideoSettingsButton = value.equalsIgnoreCase("true");
        }
    }

    public static void loadTranslations() {
        FullscreenFix.print("Load Translations");
        class_1076 languageManager = class_310.method_1551().method_1526();
        if (languageManager == null) {
            FullscreenFix.print("Language Manager is null!");
            return;
        }
        translations.clear();
        String language = languageManager.method_4669();
        if (!language.equals("en_us")) {
            FullscreenFix.loadLanguage("en_us");
        }
        FullscreenFix.loadLanguage(language);
        FullscreenFix.print(translations.size() + " Translation keys");
    }

    private static void loadLanguage(String name) {
        InputStream stream = null;
        try {
            if (FabricLoader.getInstance().isModLoaded("fabric-api")) {
                String path = "lang/" + name + ".lang";
                Optional resource = class_310.method_1551().method_1478().method_14486(class_2960.method_60655((String)"fullscreenfix", (String)path));
                if (resource.isPresent()) {
                    stream = ((class_3298)resource.get()).method_14482();
                }
            } else {
                stream = FullscreenFix.class.getResourceAsStream("/assets/fullscreenfix/lang/" + name + ".lang");
            }
            if (stream == null) {
                return;
            }
            ConfigUtil.loadConfig(stream, (key, value) -> translations.put(key, value), '=');
        }
        catch (Exception e) {
            throw new RuntimeException("Loading language: " + name, e);
        }
    }

    public static class_2561 translate(String key) {
        String value = translations.get(key);
        if (value != null) {
            return class_2561.method_30163((String)value);
        }
        return class_2561.method_30163((String)key);
    }

    public static String translateIfExists(String key) {
        String value = translations.get(key);
        if (value != null) {
            return value;
        }
        return null;
    }

    public static String translateToString(String key) {
        return translations.get(key);
    }

    public static boolean translationExists(String key) {
        return translations.containsKey(key);
    }

    public static void debugPrint(String string) {
        if (Global.INDEV) {
            System.out.print("[FullscreenFixDebug] " + string + "\n");
        }
    }

    public static void print(String string) {
        Global.print(string);
    }

    static {
        windowNeedsUpdate = true;
        fullscreenModeWasChanged = false;
        enableModNextLaunch = Global.MOD_ENABLED;
        borderlessFullscreen = true;
        fullscreenOptimizations = true;
        autoMinimize = true;
        startInFullscreen = true;
        replaceVideoSettingsButton = true;
        translations = new HashMap<String, String>();
        fullscreenOption = FullscreenFix.createFullscreenOption();
        FullscreenFix.loadConfig();
    }
}

