/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.gui.FocusDirection;
import b100.gui.Focusable;
import b100.gui.GuiContainer;
import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class GuiScrollableList
extends GuiContainer {
    public GuiScreen screen;
    public Layout layout;
    private double scrollAmount = 0.0;
    private double maxScrollAmount = 0.0;
    private int contentHeight;
    private int scrollRegionHeight;
    private boolean scrollAmountChanged = false;

    public GuiScrollableList(GuiScreen screen, Layout layout) {
        this.screen = screen;
        this.layout = layout;
        this.isList = true;
    }

    @Override
    public void draw() {
        this.setScrollAmount(this.scrollAmount);
        if (this.scrollAmountChanged) {
            this.scrollAmountChanged = false;
            this.layout.moveElements(this);
            super.onResize();
        }
        Textures.GuiTextures textures = Textures.INSTANCE.getCurrentGuiTextures();
        int separatorSize = 2;
        this.utils.drawContext.method_25290(class_10799.field_56883, textures.menuListBackground, this.posX, this.posY + 2, 0.0f, 0.0f, this.width, this.height - 4, 32, 32);
        this.utils.drawContext.method_25290(class_10799.field_56883, textures.headerSeparator, this.posX, this.posY, 0.0f, 0.0f, this.width, 2, 32, 2);
        this.utils.drawContext.method_25290(class_10799.field_56883, textures.footerSeparator, this.posX, this.posY + this.height - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        this.utils.drawContext.method_44379(this.posX, this.posY + 2, this.posX + this.width, this.posY + this.height - 2);
        super.draw();
        this.utils.drawContext.method_44380();
    }

    @Override
    public void onResize() {
        this.scrollRegionHeight = this.getScrollRegionHeight();
        this.contentHeight = this.layout.getContentHeight(this);
        this.maxScrollAmount = Math.max(0.0, (double)(this.contentHeight - this.scrollRegionHeight));
        this.scrollAmount = Math.clamp(this.scrollAmount, 0.0, this.maxScrollAmount);
        this.layout.moveElements(this);
        super.onResize();
    }

    @Override
    public boolean scrollEvent(double horizontalAmount, double verticalAmount, double mouseX, double mouseY) {
        if (this.isInside(mouseX, mouseY)) {
            this.scroll(verticalAmount * 16.0);
            return true;
        }
        return false;
    }

    public void scroll(double amount) {
        this.setScrollAmount(this.scrollAmount - amount);
    }

    public void setScrollAmount(double newScrollAmount) {
        newScrollAmount = this.contentHeight < this.height ? (double)(-(this.height - this.contentHeight) / 2) : Math.clamp(newScrollAmount, 0.0, this.maxScrollAmount);
        if (newScrollAmount == this.scrollAmount) {
            return;
        }
        this.scrollAmount = newScrollAmount;
        this.scrollAmountChanged = true;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    public int getScrollRegionHeight() {
        return this.height;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollOffset() {
        return -class_3532.method_15357((double)this.scrollAmount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public double getMaxScrollAmount() {
        return this.maxScrollAmount;
    }

    @Override
    public GuiElement getClickElementAt(double x, double y) {
        if (!this.isInside(x, y)) {
            return null;
        }
        return super.getClickElementAt(x, y);
    }

    @Override
    public Focusable getFirstFocusableElement(FocusDirection direction) {
        Focusable lastFocusedElement = this.getLastFocusedElement();
        if (lastFocusedElement != null && direction.isTab()) {
            return lastFocusedElement;
        }
        return super.getFirstFocusableElement(direction);
    }

    @Override
    public Focusable getNextFocusable(GuiElement element, FocusDirection direction) {
        return super.getNextFocusable(element, direction);
    }

    @Override
    public void onElementAdded(GuiElement element) {
        super.onElementAdded(element);
    }

    @Override
    public void onElementRemoved(GuiElement element) {
        super.onElementRemoved(element);
    }

    @Override
    public void focusChanged(Focusable focusable) {
        GuiElement element = (GuiElement)((Object)focusable);
        if (focusable.isFocused() && this.contains(element)) {
            int offset = 0;
            if (element.posY < this.posY) {
                offset = this.posY - element.posY + 4;
            }
            if (element.posY + element.height > this.posY + this.height) {
                offset = this.posY + this.height - element.posY - element.height - 4;
            }
            if (offset != 0) {
                this.scroll(offset);
            }
        }
        super.focusChanged(focusable);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Layout {
        public void moveElements(GuiScrollableList var1);

        public int getContentHeight(GuiScrollableList var1);

        public int getContentWidth(GuiScrollableList var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ListLayout
    implements Layout {
        public int outerPadding = 5;
        public int innerPadding = 0;
        public Align align = Align.CENTER;

        @Override
        public void moveElements(GuiScrollableList list) {
            int offset = list.getScrollOffset();
            offset += this.outerPadding;
            for (int i = 0; i < list.elements.size(); ++i) {
                GuiElement element = (GuiElement)list.elements.get(i);
                int x = this.align == Align.LEFT ? list.posX + this.outerPadding : (this.align == Align.CENTER ? list.posX + list.width / 2 - element.width / 2 : list.posX + list.width - element.width - this.outerPadding);
                element.setPosition(x, list.posY + offset);
                offset += element.height;
                offset += this.innerPadding;
            }
        }

        @Override
        public int getContentHeight(GuiScrollableList list) {
            int contentHeight = 0;
            for (int i = 0; i < list.elements.size(); ++i) {
                contentHeight += ((GuiElement)list.elements.get((int)i)).height;
            }
            contentHeight += 2 * this.outerPadding;
            return contentHeight += (list.elements.size() - 1) * this.innerPadding;
        }

        @Override
        public int getContentWidth(GuiScrollableList list) {
            int contentWidth = 0;
            for (int i = 0; i < list.elements.size(); ++i) {
                contentWidth = Math.max(contentWidth, ((GuiElement)list.elements.get((int)i)).width);
            }
            return contentWidth += 2 * this.outerPadding;
        }

        @Environment(value=EnvType.CLIENT)
        public static enum Align {
            LEFT,
            CENTER,
            RIGHT;

        }
    }
}

