/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui.renderer;

import dev.imb11.skinshuffle.client.SkinShuffleClient;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.gui.renderer.GuiEntityRenderer;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3673;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SkinPreviewRenderer {
    private final class_310 client;

    public SkinPreviewRenderer(class_310 client) {
        this.client = client;
    }

    public static float getEntityRotation() {
        return (float)class_3673.method_15974() * 35.0f;
    }

    public void renderPreviewArea(class_332 graphics, int previewCenterX, int previewCenterY, int previewSpanX, int previewSpanY) {
        graphics.method_49601(previewCenterX - previewSpanX, previewCenterY - previewSpanY, previewSpanX * 2, previewSpanY * 2, -553648128);
        graphics.method_25294(previewCenterX - previewSpanX + 1, previewCenterY - previewSpanY + 1, previewCenterX + previewSpanX - 1, previewCenterY + previewSpanY - 1, 0x7F000000);
    }

    public void renderSkinPreview(class_332 graphics, SkinPreset preset, int mouseX, int mouseY, int x1, int y1, int x2, int y2, float sizeScaling, SkinShuffleConfig.SkinRenderStyle renderStyle, boolean isLoading) {
        this.renderSkinPreview(graphics, preset, mouseX, mouseY, x1, y1, x2, y2, sizeScaling, renderStyle, isLoading, 1.0f);
    }

    public void renderSkinPreview(class_332 graphics, SkinPreset preset, int mouseX, int mouseY, int x1, int y1, int x2, int y2, float sizeScaling, SkinShuffleConfig.SkinRenderStyle renderStyle, boolean isLoading, float alpha) {
        if (preset.getSkin().isLoading() || isLoading) {
            int centerX = (x1 + x2) / 2;
            int centerY = (y1 + y2) / 2;
            this.renderLoadingIndicator(graphics, centerX, centerY);
            if (preset.getSkin().isLoading()) {
                preset.getSkin().getTexture();
            }
            return;
        }
        int size = Math.min(x2 - x1, y2 - y1);
        size = (int)((float)size * sizeScaling);
        float rotation = 180.0f;
        if (SkinShuffleConfig.SkinRenderStyle.ROTATION.equals((Object)renderStyle)) {
            rotation = SkinPreviewRenderer.getEntityRotation() * SkinShuffleConfig.get().rotationMultiplier;
        }
        GuiEntityRenderer.drawEntity(graphics, x1, y1, x2, y2, size, rotation, mouseX, mouseY, preset.getSkin(), renderStyle, alpha);
    }

    public void renderLoadingIndicator(class_332 graphics, int centerX, int centerY) {
        class_327 textRenderer = this.client.field_1772;
        class_5250 txt = class_2561.method_43471((String)"skinshuffle.edit.loading");
        int textWidth = textRenderer.method_27525((class_5348)txt);
        float totalDeltaTick = SkinShuffleClient.TOTAL_TICK_DELTA * 5.0f;
        float hue = totalDeltaTick % 360.0f / 360.0f;
        int color = Color.HSBtoRGB(hue, 0.75f, 1.0f) | 0xFF000000;
        int n = centerX - textWidth / 2;
        Objects.requireNonNull(textRenderer);
        graphics.method_27535(textRenderer, (class_2561)txt, n, centerY - 9 - 80, color);
    }
}

