/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.skin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.client.config.SkinPresetManager;
import dev.imb11.skinshuffle.client.skin.FileBackedSkin;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2960;

public class ConfigSkin
extends FileBackedSkin {
    public static final class_2960 SERIALIZATION_ID = SkinShuffle.id("config");
    public static final MapCodec<ConfigSkin> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("skin_name").forGetter(skin -> skin.skinName), (App)Codec.STRING.fieldOf("model").forGetter(ConfigSkin::getModel)).apply((Applicative)instance, ConfigSkin::new));
    private final String skinName;
    private String model;

    public ConfigSkin(String skinName, String model) {
        this.skinName = skinName;
        this.model = model;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String value) {
        this.model = value;
    }

    @Override
    public class_2960 getSerializationId() {
        return SERIALIZATION_ID;
    }

    @Override
    public ConfigSkin saveToConfig() {
        return this;
    }

    @Override
    public Path getFile() {
        return SkinPresetManager.PERSISTENT_SKINS_DIR.resolve(this.skinName + ".png");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSkin that = (ConfigSkin)o;
        if (!Objects.equals(this.skinName, that.skinName)) {
            return false;
        }
        return Objects.equals(this.model, that.model);
    }

    public int hashCode() {
        int result = this.skinName != null ? this.skinName.hashCode() : 0;
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        return result;
    }
}

