/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.skin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.client.skin.FileBackedSkin;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2960;

public class FileSkin
extends FileBackedSkin {
    public static final class_2960 SERIALIZATION_ID = SkinShuffle.id("file");
    public static final MapCodec<FileSkin> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Path.of(string, new String[0]));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid path: " + string);
        }
    }, Path::toString).fieldOf("path").forGetter(skin -> skin.file), (App)Codec.STRING.fieldOf("model").forGetter(FileSkin::getModel)).apply((Applicative)instance, FileSkin::new));
    private final Path file;
    private String model;

    public FileSkin(Path file, String model) {
        this.file = file;
        this.model = model;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String value) {
        this.model = value;
    }

    @Override
    public class_2960 getSerializationId() {
        return SERIALIZATION_ID;
    }

    @Override
    public Path getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSkin fileSkin = (FileSkin)o;
        if (!Objects.equals(this.file, fileSkin.file)) {
            return false;
        }
        return Objects.equals(this.model, fileSkin.model);
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        return result;
    }
}

