/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.skin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.client.skin.ConfigSkin;
import dev.imb11.skinshuffle.client.skin.FileBackedSkin;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import kong.unirest.Unirest;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class UrlSkin
extends FileBackedSkin {
    public static final Int2ObjectMap<String> MODEL_CACHE = new Int2ObjectOpenHashMap();
    public static final class_2960 SERIALIZATION_ID = SkinShuffle.id("url");
    public static final MapCodec<UrlSkin> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("url").forGetter(skin -> skin.url), (App)Codec.STRING.optionalFieldOf("model").forGetter(skin -> Optional.ofNullable(skin.model))).apply((Applicative)instance, UrlSkin::new));
    protected String url;
    protected String model;

    public UrlSkin(String url, String model) {
        this.url = url;
        this.model = model;
    }

    private UrlSkin(String url, Optional<String> model) {
        this.url = url;
        this.model = model.orElse(null);
    }

    protected UrlSkin(@Nullable String model) {
        this.model = model;
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.tryLoadModelFromCache();
        }
        return this.model == null ? "classic" : this.model;
    }

    @Override
    public void setModel(String value) {
        this.model = value;
    }

    @Override
    public class_2960 getSerializationId() {
        return SERIALIZATION_ID;
    }

    @Override
    protected Object getTextureUniqueness() {
        return this.url;
    }

    @Override
    public ConfigSkin saveToConfig() {
        try {
            if (this.model == null) {
                throw new RuntimeException("Model is not loaded yet");
            }
            String textureName = String.valueOf(Math.abs(this.getTextureUniqueness().hashCode()));
            ConfigSkin configSkin = new ConfigSkin(textureName, this.getModel());
            byte[] bytes = (byte[])Unirest.get((String)this.url).asBytes().getBody();
            Files.write(configSkin.getFile(), bytes, new OpenOption[0]);
            return configSkin;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save skin to config", e);
        }
    }

    @Override
    @Nullable
    protected class_1044 loadTexture(Runnable completionCallback) {
        try {
            Path cacheFolder = SkinShuffle.DATA_DIR.resolve("skins/downloaded");
            if (!cacheFolder.toFile().exists()) {
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
            }
            Path temporaryFilePath = this.getFile();
            String url = this.getUrl();
            InputStream in = new URI(url).toURL().openStream();
            Files.copy(in, temporaryFilePath, StandardCopyOption.REPLACE_EXISTING);
            in.close();
            return super.loadTexture(completionCallback);
        }
        catch (Exception e) {
            SkinShuffle.LOGGER.warn("Failed to load skin from URL: {}", (Object)this.url, (Object)e);
            return null;
        }
    }

    @Override
    protected Path getFile() {
        return SkinShuffle.DATA_DIR.resolve("skins/downloaded").resolve(this.getTextureUniqueness().hashCode() + ".png");
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlSkin urlSkin = (UrlSkin)o;
        if (!Objects.equals(this.url, urlSkin.url)) {
            return false;
        }
        return Objects.equals(this.model, urlSkin.model);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        return result;
    }

    protected void cacheModel() {
        MODEL_CACHE.put(this.getTextureUniqueness().hashCode(), (Object)this.getModel());
    }

    protected void tryLoadModelFromCache() {
        String model = (String)MODEL_CACHE.get(this.getTextureUniqueness().hashCode());
        if (model != null) {
            this.setModel(model);
        }
    }
}

