/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.util;

import dev.imb11.skinshuffle.client.preset.SkinPreset;
import dev.imb11.skinshuffle.client.skin.FileSkin;
import dev.imb11.skinshuffle.client.skin.ResourceSkin;
import dev.imb11.skinshuffle.client.skin.Skin;
import dev.imb11.skinshuffle.client.skin.UUIDSkin;
import dev.imb11.skinshuffle.client.skin.UrlSkin;
import dev.imb11.skinshuffle.client.skin.UsernameSkin;
import dev.imb11.skinshuffle.client.util.ValidationUtils;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2960;

public class SkinLoader {
    public static CompletableFuture<Void> loadSkin(SourceType sourceType, String source, String model, SkinPreset preset) {
        Skin skin;
        if (source.isEmpty() || sourceType == SourceType.UNCHANGED) {
            return CompletableFuture.completedFuture(null);
        }
        if (sourceType == SourceType.FILE || sourceType == SourceType.URL) {
            source = ValidationUtils.normalizeFilePath(source);
        }
        if ((skin = SkinLoader.createSkin(sourceType, source, model)) == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            preset.setSkin(skin.saveToConfig());
            skin.getTexture();
            while (preset.getSkin().isLoading()) {
                Thread.onSpinWait();
            }
        }, (Executor)class_156.method_27958());
    }

    private static Skin createSkin(SourceType sourceType, String source, String model) {
        return switch (sourceType.ordinal()) {
            case 3 -> new UrlSkin(source, model);
            case 5 -> new FileSkin(Path.of(source, new String[0]), model);
            case 2 -> new UUIDSkin(UUID.fromString(source), model);
            case 1 -> new UsernameSkin(source, model);
            case 4 -> new ResourceSkin(class_2960.method_12829((String)source), model);
            default -> Skin.randomDefaultSkin();
        };
    }

    public static enum SourceType {
        UNCHANGED,
        USERNAME,
        UUID,
        URL,
        RESOURCE_LOCATION,
        FILE;


        public String getInvalidInputTranslationKey() {
            return "skinshuffle.edit.source.invalid_" + this.name().toLowerCase();
        }

        public String getTranslationKey() {
            return "skinshuffle.edit.source." + this.name().toLowerCase();
        }
    }
}

