/*
 * Decompiled with CFR 0.152.
 */
package fuzs.paperdoll.client.handler;

import fuzs.paperdoll.PaperDoll;
import fuzs.paperdoll.client.util.PaperDollRenderer;
import fuzs.paperdoll.config.ClientConfig;
import fuzs.paperdoll.config.DisplayAction;
import fuzs.puzzleslib.api.client.gui.v2.AnchorPoint;
import net.minecraft.class_10209;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import net.minecraft.class_9779;

public class PaperDollHandler {
    static final float MAX_ROTATION_DEGREES = 30.0f;
    static final float DEFAULT_ROTATION_DEGREES = 15.0f;
    static final float SPIN_BACK_SPEED = 10.0f;
    private static int remainingDisplayTicks;
    private static int remainingRidingTicks;
    private static float yRotOffset;
    private static float yRotOffsetO;

    public static void onEndClientTick(class_310 minecraft) {
        if (minecraft.field_1724 == null || minecraft.method_1493()) {
            return;
        }
        ClientConfig config = (ClientConfig)PaperDoll.CONFIG.get(ClientConfig.class);
        if (DisplayAction.isActive(config.displayActions, (class_1657)minecraft.field_1724, remainingRidingTicks)) {
            remainingDisplayTicks = config.displayTime;
        } else if (remainingDisplayTicks > 0) {
            --remainingDisplayTicks;
        }
        if (remainingDisplayTicks > 0 || config.displayTime == 0) {
            PaperDollHandler.tickYRotOffset((class_1657)minecraft.field_1724);
        } else {
            yRotOffsetO = 0.0f;
            yRotOffset = 0.0f;
        }
        if (minecraft.field_1724.method_5765()) {
            remainingRidingTicks = Math.max(0, config.displayTime - 2);
        } else if (remainingRidingTicks > 0) {
            --remainingRidingTicks;
        }
    }

    private static void tickYRotOffset(class_1657 player) {
        yRotOffsetO = yRotOffset;
        yRotOffset = class_3532.method_15363((float)(yRotOffset + (player.field_6241 - player.field_6259) * 0.5f), (float)-30.0f, (float)30.0f);
        float nextYRotOffset = yRotOffset - yRotOffset / 10.0f;
        yRotOffset = yRotOffset < 0.0f ? Math.min(0.0f, nextYRotOffset) : (yRotOffset > 0.0f ? Math.max(0.0f, nextYRotOffset) : 0.0f);
    }

    public static void renderPaperDoll(class_332 guiGraphics, class_9779 deltaTracker) {
        class_10209.method_64146().method_15396("paperDoll");
        class_310 minecraft = class_310.method_1551();
        if (!(minecraft.field_1690.field_1842 || minecraft.field_1724 == null || minecraft.field_1724.method_5767() || minecraft.field_1724.method_7325())) {
            ClientConfig config = (ClientConfig)PaperDoll.CONFIG.get(ClientConfig.class);
            if (!(!minecraft.field_1690.method_31044().method_31034() && config.firstPersonOnly || remainingDisplayTicks <= 0 && config.displayTime != 0)) {
                float partialTick = deltaTracker.method_60637(false);
                int scale = config.scale * 5;
                int size = scale * 7 / 2;
                AnchorPoint.Positioner positioner = config.anchorPoint.createPositioner(guiGraphics.method_51421(), guiGraphics.method_51443(), size, size);
                class_8030 rectangle = positioner.getRectangle(config.offsetX, config.offsetY);
                PaperDollRenderer.renderEntityInInventory(guiGraphics, rectangle.method_49620(), rectangle.method_49618(), rectangle.method_49621(), rectangle.method_49619(), scale, 0.0f, (class_1309)minecraft.field_1724, partialTick);
            }
        }
        class_10209.method_64146().method_15407();
    }

    public static void applyEntityRotations(class_1309 entity) {
        float defaultRotationYaw;
        ClientConfig config = (ClientConfig)PaperDoll.CONFIG.get(ClientConfig.class);
        ClientConfig.HeadMovement headMovement = config.headMovement;
        if (headMovement == ClientConfig.HeadMovement.YAW || entity.method_6128()) {
            entity.method_36457(7.5f);
            entity.field_6004 = 7.5f;
        }
        entity.field_6283 = entity.field_6220 = (defaultRotationYaw = PaperDollHandler.getDefaultRotationYaw(config.anchorPoint));
        if (headMovement == ClientConfig.HeadMovement.PITCH) {
            entity.field_6241 = entity.field_6259 = defaultRotationYaw;
        } else {
            entity.field_6259 = defaultRotationYaw + yRotOffsetO;
            entity.field_6241 = defaultRotationYaw + yRotOffset;
        }
    }

    static float getDefaultRotationYaw(AnchorPoint anchorPoint) {
        return 180.0f + (anchorPoint.isRight() ? 15.0f : -15.0f);
    }
}

