/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import terrablender.core.TerraBlender;
import terrablender.util.WeightedEntry;

public class EndBiomeRegistry {
    private static final List<WeightedEntry.Wrapper<class_5321<class_1959>>> highlandsBiomes = new ArrayList<WeightedEntry.Wrapper<class_5321<class_1959>>>();
    private static final List<WeightedEntry.Wrapper<class_5321<class_1959>>> midlandsBiomes = new ArrayList<WeightedEntry.Wrapper<class_5321<class_1959>>>();
    private static final List<WeightedEntry.Wrapper<class_5321<class_1959>>> edgeBiomes = new ArrayList<WeightedEntry.Wrapper<class_5321<class_1959>>>();
    private static final List<WeightedEntry.Wrapper<class_5321<class_1959>>> islandBiomes = new ArrayList<WeightedEntry.Wrapper<class_5321<class_1959>>>();

    public static void registerHighlandsBiome(class_5321<class_1959> biome, int weight) {
        highlandsBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static void registerMidlandsBiome(class_5321<class_1959> biome, int weight) {
        midlandsBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static void registerEdgeBiome(class_5321<class_1959> biome, int weight) {
        edgeBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static void registerIslandBiome(class_5321<class_1959> biome, int weight) {
        islandBiomes.add(WeightedEntry.wrap(biome, weight));
    }

    public static List<WeightedEntry.Wrapper<class_5321<class_1959>>> getHighlandsBiomes() {
        return ImmutableList.copyOf(highlandsBiomes);
    }

    public static List<WeightedEntry.Wrapper<class_5321<class_1959>>> getMidlandsBiomes() {
        return ImmutableList.copyOf(midlandsBiomes);
    }

    public static List<WeightedEntry.Wrapper<class_5321<class_1959>>> getEdgeBiomes() {
        return ImmutableList.copyOf(edgeBiomes);
    }

    public static List<WeightedEntry.Wrapper<class_5321<class_1959>>> getIslandBiomes() {
        return ImmutableList.copyOf(islandBiomes);
    }

    static {
        EndBiomeRegistry.registerHighlandsBiome((class_5321<class_1959>)class_1972.field_9442, TerraBlender.CONFIG.vanillaEndHighlandsWeight);
        EndBiomeRegistry.registerMidlandsBiome((class_5321<class_1959>)class_1972.field_9447, TerraBlender.CONFIG.vanillaEndMidlandsWeight);
        EndBiomeRegistry.registerEdgeBiome((class_5321<class_1959>)class_1972.field_9465, TerraBlender.CONFIG.vanillaEndBarrensWeight);
        EndBiomeRegistry.registerIslandBiome((class_5321<class_1959>)class_1972.field_9457, TerraBlender.CONFIG.vanillaSmallEndIslandsWeight);
    }
}

