/*
 * Decompiled with CFR 0.152.
 */
package net.taylor.hoesarescythes;

import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.taylor.hoesarescythes.logic.RadiusResolver;
import net.taylor.hoesarescythes.logic.ScythePredicate;

public final class ClearGrass {
    private ClearGrass() {
    }

    public static void register() {
        AttackBlockCallback.EVENT.register(ClearGrass::onAttackBlock);
    }

    private static class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 face) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        class_1799 tool = player.method_5998(hand);
        if (player.method_5715() || !(tool.method_7909() instanceof class_1794)) {
            return class_1269.field_5811;
        }
        int radius = RadiusResolver.getRadius(tool);
        if (radius <= 0) {
            return class_1269.field_5811;
        }
        class_2680 state = world.method_8320(pos);
        if (!ClearGrass.isValidInitialTarget(state)) {
            return class_1269.field_5811;
        }
        boolean didWork = ClearGrass.breakBlocksInRadius(player, (class_3218)world, hand, pos, state, tool, radius);
        return didWork ? class_1269.field_5812 : class_1269.field_5811;
    }

    private static boolean breakBlocksInRadius(class_1657 player, class_3218 world, class_1268 hand, class_2338 origin, class_2680 initial, class_1799 tool, int radius) {
        boolean didWork = false;
        boolean targetingCrop = initial.method_26164(class_3481.field_20341);
        boolean targetingNetherWart = initial.method_27852(class_2246.field_9974);
        boolean targetingFullyGrown = ClearGrass.isFullyGrownCrop(initial);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                mutable.method_10103(origin.method_10263() + dx, origin.method_10264(), origin.method_10260() + dz);
                didWork = ClearGrass.tryBreakBlock(player, world, hand, (class_2338)mutable, targetingCrop, targetingNetherWart, targetingFullyGrown, tool) || didWork;
            }
        }
        return didWork;
    }

    private static boolean tryBreakBlock(class_1657 player, class_3218 world, class_1268 hand, class_2338 pos, boolean targetingCrop, boolean targetingNetherWart, boolean targetingFullyGrown, class_1799 tool) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        if (!player.method_31549().field_7476) {
            return false;
        }
        if (world.method_8503().method_3785(world, pos, player)) {
            return false;
        }
        if (!ClearGrass.shouldBreakBlock(targetingCrop, targetingFullyGrown, targetingNetherWart, state)) {
            return false;
        }
        boolean broke = world.method_22352(pos, !player.method_31549().field_7477);
        if (!broke) {
            return false;
        }
        if (!player.method_31549().field_7477 && tool.method_7963()) {
            tool.method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
        }
        return true;
    }

    private static boolean isValidInitialTarget(class_2680 state) {
        return state.method_26164(class_3481.field_20341) || state.method_27852(class_2246.field_9974) || ScythePredicate.isScythable(state);
    }

    private static boolean shouldBreakBlock(boolean targetingCrop, boolean targetingFullyGrown, boolean targetingNetherWart, class_2680 state) {
        if (targetingCrop && state.method_26164(class_3481.field_20341)) {
            return !targetingFullyGrown || ClearGrass.isFullyGrownCrop(state);
        }
        if (targetingNetherWart && state.method_27852(class_2246.field_9974)) {
            return !targetingFullyGrown || ClearGrass.isFullyGrownCrop(state);
        }
        return !targetingCrop && !targetingNetherWart && ScythePredicate.isScythable(state);
    }

    private static boolean isFullyGrownCrop(class_2680 state) {
        for (class_2769 property : state.method_28501()) {
            int maxAge;
            if (!(property instanceof class_2758)) continue;
            class_2758 age = (class_2758)property;
            if (!property.method_11899().equals("age")) continue;
            int ageValue = (Integer)state.method_11654((class_2769)age);
            return ageValue == (maxAge = age.method_11898().stream().max(Integer::compareTo).orElse(0).intValue());
        }
        return false;
    }
}

