/*
 * Decompiled with CFR 0.152.
 */
package net.taylor.hoesarescythes.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.taylor.hoesarescythes.config.ModConfig;

public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "hoesarescythes.json";
    private static ModConfig CURRENT = new ModConfig();

    private ConfigManager() {
    }

    public static Path path() {
        return FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
    }

    public static ModConfig get() {
        return CURRENT;
    }

    public static void loadOrCreateDefault() {
        Path p = ConfigManager.path();
        if (!Files.exists(p, new LinkOption[0])) {
            ConfigManager.writeDefault(p);
        }
        try {
            String json = Files.readString(p);
            ModConfig cfg = (ModConfig)GSON.fromJson(json, ModConfig.class);
            if (cfg == null) {
                cfg = new ModConfig();
            }
            CURRENT = cfg;
        }
        catch (Exception e) {
            System.err.println("[HoesAreScythes] Failed to read config, keeping previous: " + e.getMessage());
        }
    }

    private static void writeDefault(Path p) {
        try {
            ModConfig def = new ModConfig();
            def.hoes.add(ConfigManager.entry("minecraft:wooden_hoe", 1));
            def.hoes.add(ConfigManager.entry("minecraft:stone_hoe", 1));
            def.hoes.add(ConfigManager.entry("minecraft:iron_hoe", 2));
            def.hoes.add(ConfigManager.entry("minecraft:diamond_hoe", 3));
            def.hoes.add(ConfigManager.entry("minecraft:netherite_hoe", 4));
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.writeString(p, (CharSequence)GSON.toJson((Object)def), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static ModConfig.HEntry entry(String id, int radius) {
        ModConfig.HEntry e = new ModConfig.HEntry();
        e.item = id;
        e.radius = radius;
        return e;
    }
}

