/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge;

import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.AbstractPluginPacketSender;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.CommonPacketPayload;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoforgePluginPacketSender
extends AbstractPluginPacketSender {
    private static BiConsumer<IServerPlayerWrapper, AbstractNetworkMessage> packetConsumer;

    public static void setPacketHandler(RegisterPayloadHandlersEvent event, Consumer<AbstractNetworkMessage> consumer) {
        NeoforgePluginPacketSender.setPacketHandler(event, (IServerPlayerWrapper player, AbstractNetworkMessage buffer) -> consumer.accept((AbstractNetworkMessage)buffer));
    }

    public static void setPacketHandler(RegisterPayloadHandlersEvent event, BiConsumer<IServerPlayerWrapper, AbstractNetworkMessage> consumer) {
        packetConsumer = consumer;
        PayloadRegistrar registrar = event.registrar("1").optional();
        registrar.playBidirectional(CommonPacketPayload.TYPE, (StreamCodec)new CommonPacketPayload.Codec(), (payload, context) -> {
            ServerPlayerWrapper serverPlayer = Optional.of(context.player()).map(player -> player instanceof ServerPlayer ? (ServerPlayer)player : null).map(ServerPlayerWrapper::getWrapper).orElse(null);
            if (payload.message() != null) {
                packetConsumer.accept(serverPlayer, payload.message());
            }
        });
    }

    public static void registerClientPacketHandler(RegisterClientPayloadHandlersEvent event) {
        event.register(CommonPacketPayload.TYPE, (payload, context) -> {
            if (payload.message() != null) {
                packetConsumer.accept(null, payload.message());
            }
        });
    }

    @Override
    public void sendToServer(AbstractNetworkMessage message) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new CommonPacketPayload(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClient(ServerPlayer serverPlayer, AbstractNetworkMessage message) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CommonPacketPayload(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

