/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.gui.widget;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_8666;
import net.minecraft.class_9848;
import nl.enjarai.cicada.api.cursed.DummyClientPlayerEntity;
import nl.enjarai.cicada.api.screen.DrawUtils;
import nl.enjarai.showmeyourskin.ShowMeYourSkin;
import nl.enjarai.showmeyourskin.ShowMeYourSkinClient;
import nl.enjarai.showmeyourskin.client.cursed.AlwaysGlintingStack;
import nl.enjarai.showmeyourskin.config.ArmorConfig;
import nl.enjarai.showmeyourskin.config.HideableEquipment;
import nl.enjarai.showmeyourskin.config.ModConfig;
import nl.enjarai.showmeyourskin.config.SyncedModConfig;
import nl.enjarai.showmeyourskin.gui.widget.SliderSet;
import nl.enjarai.showmeyourskin.gui.widget.SliderSetTab;
import nl.enjarai.showmeyourskin.gui.widget.ToggleButtonWidget;

public class ArmorConfigWindow
extends class_362
implements class_4068,
class_364,
class_6379 {
    public static final class_2960 TEXTURE = ShowMeYourSkin.id("textures/gui/armor_screen.png");
    public static final class_2960 BACKGROUND_TEXTURE = ShowMeYourSkin.id("textures/gui/armor_screen_background.png");
    public static final class_2960 OVERLAY_TEXTURE = ShowMeYourSkin.id("textures/gui/armor_screen_disabled.png");
    private static final int TEXT_COLOR = class_9848.method_61323((int)80, (int)80, (int)80);
    private static final int TEXT_COLOR_RED = class_9848.method_61323((int)136, (int)0, (int)0);
    private static final class_2561 GLINT_TOOLTIP = class_2561.method_43471((String)"gui.showmeyourskin.armorScreen.glintTooltip");
    private static final class_2561 COMBAT_TOOLTIP = class_2561.method_43471((String)"gui.showmeyourskin.armorScreen.combatTooltip");
    private static final class_2561 NAME_TAG_TOOLTIP = class_2561.method_43471((String)"gui.showmeyourskin.armorScreen.nameTagTooltip");
    private static final class_2561 FORCE_ELYTRA_WHEN_FLYING_TOOLTIP = class_2561.method_43471((String)"gui.showmeyourskin.armorScreen.forceElytraWhenFlyingTooltip");
    protected static final class_8666 TOGGLE_GLINT_BUTTON_TEXTURES = ToggleButtonWidget.createTextures("show_glint");
    protected static final class_8666 SHOW_IN_COMBAT_BUTTON_TEXTURES = ToggleButtonWidget.createTextures("show_in_combat");
    protected static final class_8666 SHOW_NAME_TAG_BUTTON_TEXTURES = ToggleButtonWidget.createTextures("show_nametag");
    protected static final class_8666 FORCE_ELYTRA_WHEN_FLYING_BUTTON_TEXTURES = ToggleButtonWidget.createTextures("force_elytra_when_flying");
    private static final class_1799 HEAD_ARMOR = new AlwaysGlintingStack((class_1935)class_1802.field_22027);
    private static final class_1799 CHEST_ARMOR = new AlwaysGlintingStack((class_1935)class_1802.field_22028);
    private static final class_1799 LEGS_ARMOR = new AlwaysGlintingStack((class_1935)class_1802.field_22029);
    private static final class_1799 FEET_ARMOR = new AlwaysGlintingStack((class_1935)class_1802.field_22030);
    private static final class_1799 SHIELD = new AlwaysGlintingStack((class_1935)class_1802.field_8255);
    private static final class_1799 ELYTRA = new AlwaysGlintingStack((class_1935)class_1802.field_8833);
    private static final class_1799 HAT = new AlwaysGlintingStack((class_1935)class_1802.field_8681);
    private final List<class_339> buttons = Lists.newArrayList();
    private final List<class_364> children = Lists.newArrayList();
    private final List<SliderSetTab> sliderSetTabs = Lists.newArrayList();
    private SliderSetTab selectedSliderSetTab;
    private float lastPlayerRotation;
    private long lastTabSwitchTime;
    private final class_437 parent;
    public int x;
    public int y;
    private final class_2561 name;
    private final DummyClientPlayerEntity player;
    private final ArmorConfig armorConfig;

    public ArmorConfigWindow(class_437 parent, int x, int y, class_2561 name, DummyClientPlayerEntity player, ArmorConfig armorConfig, int tabIndex, boolean allowAllOptions) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.name = name;
        this.player = player;
        this.armorConfig = armorConfig;
        Optional<SyncedModConfig> serverConfig = ShowMeYourSkinClient.HANDSHAKE_CLIENT.getConfig();
        boolean hideOptions = serverConfig.isPresent() && !allowAllOptions;
        this.sliderSetTabs.add(new SliderSetTab(this.getWindowLeft() - 25, this.getWindowTop() + 12, 0, 240, new SliderSet(this, this.getWindowLeft(), this.getWindowTop(), sliders -> {
            sliders.add(this.getOpacitySlider(HideableEquipment.HEAD, 14, 11, "gui.showmeyourskin.armorScreen.piece.head"));
            sliders.add(this.getOpacitySlider(HideableEquipment.CHEST, 14, 35, "gui.showmeyourskin.armorScreen.piece.chest"));
            sliders.add(this.getOpacitySlider(HideableEquipment.LEGS, 14, 59, "gui.showmeyourskin.armorScreen.piece.legs"));
            sliders.add(this.getOpacitySlider(HideableEquipment.FEET, 14, 83, "gui.showmeyourskin.armorScreen.piece.feet"));
            sliders.add(this.getGlintButton(HideableEquipment.HEAD, 94, 11));
            sliders.add(this.getGlintButton(HideableEquipment.CHEST, 94, 35));
            sliders.add(this.getGlintButton(HideableEquipment.LEGS, 94, 59));
            sliders.add(this.getGlintButton(HideableEquipment.FEET, 94, 83));
        }, ArmorConfigWindow::getDummyArmor, 0.0f, (class_3414)class_3417.field_21866.comp_349())));
        this.sliderSetTabs.add(new SliderSetTab(this.getWindowLeft() - 25, this.getWindowTop() + 42, 16, 240, new SliderSet(this, this.getWindowLeft(), this.getWindowTop(), sliders -> {
            sliders.add(this.getOpacitySlider(HideableEquipment.ELYTRA, 14, 11, "gui.showmeyourskin.armorScreen.piece.elytra"));
            sliders.add(this.getOpacitySlider(HideableEquipment.HAT, 14, 35, "gui.showmeyourskin.armorScreen.piece.hat"));
            sliders.add(this.getGlintButton(HideableEquipment.ELYTRA, 94, 11));
            sliders.add(this.getGlintButton(HideableEquipment.HAT, 94, 35));
        }, ArmorConfigWindow::getDummyEquipment, -180.0f, (class_3414)class_3417.field_14966.comp_349())));
        this.selectTab(this.sliderSetTabs.get(tabIndex));
        this.lastPlayerRotation = this.selectedSliderSetTab.sliderSet.rotatedBy;
        if (!hideOptions || serverConfig.get().allowNotShowInCombat()) {
            this.buttons.add((class_339)new ToggleButtonWidget(this.getWindowLeft() + 14, this.getWindowTop() + 115, 20, 20, SHOW_IN_COMBAT_BUTTON_TEXTURES, armorConfig.showInCombat, (btn, b) -> {
                armorConfig.showInCombat = b;
            }, COMBAT_TOOLTIP));
        }
        if (!hideOptions || serverConfig.get().allowNotShowNameTag()) {
            this.buttons.add((class_339)new ToggleButtonWidget(this.getWindowLeft() + 40, this.getWindowTop() + 115, 20, 20, SHOW_NAME_TAG_BUTTON_TEXTURES, armorConfig.showNameTag, (btn, b) -> {
                armorConfig.showNameTag = b;
            }, NAME_TAG_TOOLTIP));
        }
        if (!hideOptions || serverConfig.get().allowNotForceElytraWhenFlying()) {
            this.buttons.add((class_339)new ToggleButtonWidget(this.getWindowLeft() + 66, this.getWindowTop() + 115, 20, 20, FORCE_ELYTRA_WHEN_FLYING_BUTTON_TEXTURES, armorConfig.forceElytraWhenFlying, (btn, b) -> {
                armorConfig.forceElytraWhenFlying = b;
            }, FORCE_ELYTRA_WHEN_FLYING_TOOLTIP));
        }
        this.children.addAll(this.buttons);
    }

    protected int getWindowLeft() {
        return this.x;
    }

    protected int getWindowRight() {
        return this.getWindowLeft() + 236;
    }

    protected int getWindowTop() {
        return this.y;
    }

    protected int getWindowBottom() {
        return this.getWindowTop() + 16 + 16 * this.getHeightIterations();
    }

    protected int getHeightIterations() {
        return 10;
    }

    public ArmorConfig getArmorConfig() {
        return this.armorConfig;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        for (SliderSetTab sliderSetTabs : this.sliderSetTabs) {
            sliderSetTabs.render(context, mouseX, mouseY, sliderSetTabs == this.selectedSliderSetTab);
        }
        this.renderBackground(context, BACKGROUND_TEXTURE);
        for (class_339 drawable : this.buttons) {
            drawable.method_25394(context, this.isEditable() ? mouseX : -1, this.isEditable() ? mouseY : -1, delta);
        }
        this.selectedSliderSetTab.sliderSet.method_25394(context, this.isEditable() ? mouseX : -1, this.isEditable() ? mouseY : -1, delta);
        class_327 textRenderer = class_310.method_1551().field_1772;
        context.method_51439(textRenderer, this.name, this.getWindowRight() - 110, this.getWindowTop() + 10, TEXT_COLOR, false);
        if (this.isOverridden()) {
            class_5250 text = class_2561.method_43471((String)"gui.showmeyourskin.armorScreen.overridden");
            context.method_51439(textRenderer, (class_2561)text, this.getWindowRight() - 7 - textRenderer.method_27525((class_5348)text), this.getWindowTop() + 10, TEXT_COLOR_RED, false);
        }
        context.method_44379(this.getWindowRight() - 112, this.getWindowTop() + 8, this.getWindowRight() - 5, this.getWindowTop() + 168);
        this.player.field_52447.method_61403();
        DrawUtils.drawEntityFollowingMouse((class_332)context, (int)(this.getWindowRight() - 112), (int)(this.getWindowTop() - 108), (int)(this.getWindowRight() - 5), (int)(this.getWindowTop() + 168), (int)70, (float)1.0f, (double)this.getCurrentPlayerRotation(), (double)mouseX, (double)(mouseY - 65), (class_1309)this.player);
        context.method_44380();
        if (!this.isEditable()) {
            this.renderBackground(context, OVERLAY_TEXTURE);
        }
    }

    private float getPlayerRotationDelta() {
        double delta = class_3532.method_15350((double)((double)(System.currentTimeMillis() - this.lastTabSwitchTime) / 500.0), (double)0.0, (double)1.0);
        return (float)Math.sin(delta * Math.PI / 2.0);
    }

    private float getCurrentPlayerRotation() {
        return class_3532.method_16439((float)this.getPlayerRotationDelta(), (float)this.lastPlayerRotation, (float)this.selectedSliderSetTab.sliderSet.rotatedBy);
    }

    public void renderBackground(class_332 context, class_2960 backgroundTexture) {
        int leftSide = this.getWindowLeft() + 3;
        int topSide = this.getWindowTop();
        context.method_25290(class_10799.field_56883, backgroundTexture, leftSide, topSide, 1.0f, 1.0f, 236, 254, 256, 256);
    }

    protected class_357 getOpacitySlider(HideableEquipment slot, int x, int y, final String translationKey) {
        final ArmorConfig.ArmorPieceConfig pieceConfig = this.armorConfig.getPieces().get((Object)slot);
        final ArmorConfig.ArmorPieceConfig trimConfig = this.armorConfig.getTrims().get(slot.toSlot());
        byte initialValue = pieceConfig.getTransparency();
        return new class_357(this, this.getWindowLeft() + x, this.getWindowTop() + y, 77, 20, (class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{initialValue}), (float)initialValue / 100.0f){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{(byte)(this.field_22753 * 100.0)}));
            }

            protected void method_25344() {
                pieceConfig.setTransparency((byte)(this.field_22753 * 100.0));
                if (trimConfig != null) {
                    trimConfig.setTransparency((byte)(this.field_22753 * 100.0));
                }
            }

            public void method_25354(class_1144 soundManager) {
                soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }

            public void method_25357(double mouseX, double mouseY) {
            }
        };
    }

    protected class_357 getSlider(int x, int y, int width, final int minValue, final int maxValue, int initialValue, final Consumer<Integer> onValueChange, final String translationKey) {
        return new class_357(this, this.getWindowLeft() + x, this.getWindowTop() + y, width, 20, (class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{initialValue}), (float)(initialValue - minValue) / (float)(maxValue - minValue)){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{(int)class_3532.method_16436((double)this.field_22753, (double)minValue, (double)maxValue)}));
            }

            protected void method_25344() {
                onValueChange.accept((int)class_3532.method_16436((double)this.field_22753, (double)minValue, (double)maxValue));
            }

            public void method_25354(class_1144 soundManager) {
                soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }

            public void method_25357(double mouseX, double mouseY) {
            }
        };
    }

    protected ToggleButtonWidget getGlintButton(HideableEquipment slot, int x, int y) {
        return new ToggleButtonWidget(this.getWindowLeft() + x, this.getWindowTop() + y, 20, 20, TOGGLE_GLINT_BUTTON_TEXTURES, this.armorConfig.getGlints().get((Object)slot).getTransparency() > 0, (btn, b) -> this.armorConfig.getGlints().get((Object)slot).setTransparency((byte)(b != false ? 100 : 0)), GLINT_TOOLTIP);
    }

    public boolean isEditable() {
        return ModConfig.INSTANCE.globalEnabled;
    }

    public boolean isOverridden() {
        return false;
    }

    public void selectTab(SliderSetTab sliderSetTab) {
        if (this.selectedSliderSetTab != null) {
            this.lastPlayerRotation = this.getCurrentPlayerRotation();
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)sliderSetTab.sliderSet.sound, (float)1.0f));
        }
        this.lastTabSwitchTime = System.currentTimeMillis();
        this.selectedSliderSetTab = sliderSetTab;
        this.player.equippedStackSupplier = sliderSetTab.sliderSet.dummyEquipmentGetter;
    }

    public int getTabIndex() {
        return this.sliderSetTabs.indexOf(this.selectedSliderSetTab);
    }

    public void method_37020(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        for (class_364 element : this.children) {
            if (!element.method_25405(mouseX, mouseY)) continue;
            return true;
        }
        for (SliderSetTab sliderSetTab : this.sliderSetTabs) {
            if (!sliderSetTab.isMouseOver(mouseX, mouseY)) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.selectTab(sliderSetTab);
            return true;
        }
        if (this.selectedSliderSetTab.sliderSet.method_25405(mouseX, mouseY)) {
            return true;
        }
        return super.method_25405(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isEditable()) {
            return false;
        }
        for (SliderSetTab sliderSetTab : this.sliderSetTabs) {
            if (!sliderSetTab.isMouseOver(mouseX, mouseY)) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.selectTab(sliderSetTab);
            return true;
        }
        if (this.selectedSliderSetTab.sliderSet.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isEditable()) {
            return false;
        }
        if (this.selectedSliderSetTab.sliderSet.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    private static class_1799 getDummyArmor(class_1304 slot) {
        return switch (slot) {
            case class_1304.field_6169 -> HEAD_ARMOR;
            case class_1304.field_6174 -> CHEST_ARMOR;
            case class_1304.field_6172 -> LEGS_ARMOR;
            case class_1304.field_6166 -> FEET_ARMOR;
            default -> class_1799.field_8037;
        };
    }

    private static class_1799 getDummyEquipment(class_1304 slot) {
        return switch (slot) {
            case class_1304.field_6171 -> SHIELD;
            case class_1304.field_6174 -> ELYTRA;
            case class_1304.field_6169 -> HAT;
            default -> class_1799.field_8037;
        };
    }
}

