/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.net;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_3222;
import nl.enjarai.showmeyourskin.ShowMeYourSkin;
import nl.enjarai.showmeyourskin.config.SyncedModConfig;
import nl.enjarai.showmeyourskin.net.ConfigSyncPacket;
import nl.enjarai.showmeyourskin.net.SyncConfirmPacket;

public class HandshakeServer {
    private final Supplier<SyncedModConfig> configSupplier;
    private final Map<class_3222, HandshakeState> syncStates = new WeakHashMap<class_3222, HandshakeState>();

    public HandshakeServer(Supplier<SyncedModConfig> configSupplier) {
        this.configSupplier = configSupplier;
    }

    public HandshakeState getHandshakeState(class_3222 player) {
        return this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT);
    }

    public ConfigSyncPacket getSyncPacket(class_3222 player) {
        return new ConfigSyncPacket(this.configSupplier.get());
    }

    public void configSentToClient(class_3222 player) {
        this.syncStates.put(player, HandshakeState.SENT);
    }

    public HandshakeState clientReplied(class_3222 player, SyncConfirmPacket packet) {
        HandshakeState state = this.getHandshakeState(player);
        if (state == HandshakeState.SENT) {
            if (packet.success()) {
                this.syncStates.put(player, HandshakeState.ACCEPTED);
                ShowMeYourSkin.LOGGER.info("Client of {} accepted server config.", (Object)player.method_5477().getString());
                return HandshakeState.ACCEPTED;
            }
            this.syncStates.put(player, HandshakeState.FAILED);
            ShowMeYourSkin.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.method_5477().getString());
            return HandshakeState.FAILED;
        }
        return state;
    }

    public void playerDisconnected(class_3222 player) {
        this.syncStates.remove(player);
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED;

    }
}

