/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment.builder;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public abstract class DataAttachmentBuilder<T, V, B extends DataAttachmentRegistry.Builder<T, V, B>>
implements DataAttachmentRegistry.Builder<T, V, B> {
    protected final Map<Predicate<T>, Function<class_5455, V>> defaultValues = new LinkedHashMap<Predicate<T>, Function<class_5455, V>>();
    @Nullable
    protected Codec<V> codec;
    @Nullable
    protected class_9139<? super class_9129, V> streamCodec;
    @Nullable
    private Function<T, PlayerSet> synchronizationTargets;

    @Override
    public B defaultValue(Function<class_5455, V> defaultValueProvider) {
        Objects.requireNonNull(defaultValueProvider, "default value provider is null");
        this.defaultValues.put((Predicate<T>)Predicates.alwaysTrue(), (Function<class_5455, Function<class_5455, V>>)defaultValueProvider);
        return this.getThis();
    }

    @Override
    public B persistent(Codec<V> codec) {
        Objects.requireNonNull(codec, "codec is null");
        this.codec = codec;
        return this.getThis();
    }

    @Override
    public B networkSynchronized(class_9139<? super class_9129, V> streamCodec, Function<T, PlayerSet> synchronizationTargets) {
        Objects.requireNonNull(streamCodec, "stream codec is null");
        Objects.requireNonNull(synchronizationTargets, "synchronization targets is null");
        this.streamCodec = streamCodec;
        this.synchronizationTargets = synchronizationTargets;
        return this.getThis();
    }

    protected boolean syncWith(T holder, class_3222 serverPlayer) {
        Objects.requireNonNull(this.synchronizationTargets, "synchronization targets is null");
        MutableBoolean mutableBoolean = new MutableBoolean();
        this.synchronizationTargets.apply(holder).apply(serverPlayerX -> {
            if (serverPlayer == serverPlayerX) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.booleanValue();
    }
}

