/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.class_1923;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3532;
import net.minecraft.class_5539;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6574;
import net.minecraft.class_6575;
import net.minecraft.class_6953;

public class AquiferSamplerProvider {
    private static final int FAR_LANDS_BOUNDARY = 12550821;
    private final class_6953 noiseRouter;
    private final class_6574 randomSplitter;
    private final class_6350.class_6565 fluidLevelSampler;
    private final class_6350.class_6565 lavalessFluidLevelSampler;
    private final class_6568 chunkSampler;
    private final int worldMinY;
    private final int worldHeight;
    private final int noiseResolutionVertical;
    private final boolean generateAquifers;

    public AquiferSamplerProvider(class_6953 noiseRouter, class_2680 defaultFluid, int seaLevel, int lavaLevel) {
        this(noiseRouter, new class_6575(-1L).method_38421(), null, defaultFluid, seaLevel, lavaLevel, 0, 0, 0, false);
    }

    public AquiferSamplerProvider(class_6953 noiseRouter, class_6574 randomSplitter, class_6568 chunkSampler, class_2680 defaultFluid, int seaLevel, int lavaLevel, int worldMinY, int worldHeight, int noiseResolutionVertical, boolean generateAquifers) {
        this.noiseRouter = noiseRouter;
        this.randomSplitter = randomSplitter.method_39000(ModernerBeta.createId("aquifer")).method_38421();
        class_6350.class_6351 lavaFluidLevel = new class_6350.class_6351(lavaLevel, BlockStates.LAVA);
        class_6350.class_6351 seaFluidLevel = new class_6350.class_6351(seaLevel, defaultFluid);
        this.fluidLevelSampler = (x, y, z) -> {
            if (Math.abs(x) >= 12550821 || Math.abs(z) >= 12550821) {
                return seaFluidLevel;
            }
            return y < lavaLevel ? lavaFluidLevel : seaFluidLevel;
        };
        this.lavalessFluidLevelSampler = (x, y, z) -> seaFluidLevel;
        this.chunkSampler = chunkSampler;
        this.worldMinY = worldMinY;
        this.worldHeight = worldHeight;
        this.noiseResolutionVertical = noiseResolutionVertical;
        this.generateAquifers = generateAquifers;
    }

    public class_6350 provideAquiferSampler(class_2791 chunk) {
        if (!this.generateAquifers) {
            return class_6350.method_36381((class_6350.class_6565)this.lavalessFluidLevelSampler);
        }
        int minY = Math.max(this.worldMinY, chunk.method_31607());
        int topY = Math.min(this.worldMinY + this.worldHeight, VersionCompat.getTopYExclusive((class_5539)chunk));
        int noiseMinY = class_3532.method_48116((int)minY, (int)this.noiseResolutionVertical);
        int noiseTopY = class_3532.method_48116((int)(topY - minY), (int)this.noiseResolutionVertical);
        return class_6350.method_36382((class_6568)this.chunkSampler, (class_1923)chunk.method_12004(), (class_6953)this.noiseRouter, (class_6574)this.randomSplitter, (int)(noiseMinY * this.noiseResolutionVertical), (int)(noiseTopY * this.noiseResolutionVertical), (class_6350.class_6565)this.fluidLevelSampler);
    }
}

