/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.color;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.client.color.BlockColormap;
import mod.bluestaggo.modernerbeta.mixin.AccessorBiome;
import mod.bluestaggo.modernerbeta.mixin.client.AccessorChunkRendererRegion;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4543;
import net.minecraft.class_4763;
import net.minecraft.class_6880;
import net.minecraft.class_853;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class BlockColorSampler {
    private static final int CLIME_CACHE_CAPACITY = 128;
    public static final BlockColorSampler INSTANCE = new BlockColorSampler();
    public final BlockColormap colormapGrass;
    public final BlockColormap colormapFoliage;
    public final BlockColormap colormapWater;
    public final BlockColormap colormapUnderwater;
    private ClimateSampler climateSampler = null;
    private final Long2ObjectLinkedOpenHashMap<Clime> climeCache = new Long2ObjectLinkedOpenHashMap(128);
    private final LoadingCache<Class<?>, Optional<Field>> viewLevelFieldCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<Field>>(this){
        private static final Set<String> PRIORITY_LEVEL_FIELD_NAMES = Set.of("level", "world");

        @NotNull
        public Optional<Field> load(@NotNull Class<?> clazz) {
            List<Field> potentialFields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> class_4538.class.isAssignableFrom(field.getType())).toList();
            if (potentialFields.isEmpty()) {
                return Optional.empty();
            }
            Field field2 = potentialFields.get(0);
            if (potentialFields.size() > 1) {
                field2 = potentialFields.stream().filter(f -> PRIORITY_LEVEL_FIELD_NAMES.contains(f.getName())).findFirst().orElse(field2);
            }
            if (!Modifier.isPublic(field2.getModifiers()) && !field2.trySetAccessible()) {
                return Optional.empty();
            }
            return Optional.of(field2);
        }
    });

    private BlockColorSampler() {
        this.colormapGrass = new BlockColormap();
        this.colormapFoliage = new BlockColormap();
        this.colormapWater = new BlockColormap();
        this.colormapUnderwater = new BlockColormap();
    }

    public ClimateSampler getClimateSampler() {
        return this.climateSampler;
    }

    public void setClimateSampler(ClimateSampler climateSampler) {
        this.climateSampler = climateSampler;
        this.climeCache.clear();
    }

    private Clime sampleClime(class_2338 pos) {
        return this.sampleClime(pos.method_10263(), pos.method_10260());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Clime sampleClime(int x, int z) {
        Long2ObjectLinkedOpenHashMap<Clime> long2ObjectLinkedOpenHashMap = this.climeCache;
        synchronized (long2ObjectLinkedOpenHashMap) {
            long coord = class_1923.method_8331((int)x, (int)z);
            Clime clime = (Clime)this.climeCache.get(coord);
            if (clime != null) {
                return clime;
            }
            if (this.climeCache.size() == 128) {
                this.climeCache.removeFirst();
            }
            clime = this.climateSampler.sample(x, z);
            this.climeCache.put(coord, (Object)clime);
            return clime;
        }
    }

    public int getGrassColor(class_2680 ignoredState, class_1920 view, class_2338 pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return class_1933.method_49724();
        }
        if (this.useBiomeColor()) {
            class_4543 biomeAccess = this.getBiomeAccessFromView(view);
            if (biomeAccess != null) {
                return this.sampleModifiedColorMaybeLerped(biomeAccess, pos, class_4763::method_30812, class_4763::method_30814, class_1933::method_8377);
            }
            Clime clime = this.sampleClime(pos);
            return class_1933.method_8377((double)clime.temp(), (double)clime.rain());
        }
        return class_1163.method_4962((class_1920)view, (class_2338)pos);
    }

    public int getPetalColor(class_2680 state, class_1920 view, class_2338 pos, int tintNdx) {
        if (tintNdx == 0) {
            return -1;
        }
        return this.getShortGrassColor(state, view, pos, tintNdx);
    }

    public int getTallGrassColor(class_2680 state, class_1920 view, class_2338 pos, int tintNdx) {
        return this.getShortGrassColor(state, view, state.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609 ? pos.method_10074() : pos, tintNdx);
    }

    public int getShortGrassColor(class_2680 ignoredState, class_1920 view, class_2338 pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return class_1933.method_49724();
        }
        if (this.useBiomeColor()) {
            class_4543 biomeAccess;
            if (this.getClimateDistribution().fuzzyGrass()) {
                int x = pos.method_10263();
                int y = pos.method_10264();
                int z = pos.method_10260();
                long shift = (long)x * 3129871L + (long)z * 6129781L + (long)y;
                shift = shift * shift * 42317861L + shift * 11L;
                pos = pos.method_10069((int)(shift >> 14 & 0x1FL), (int)(shift >> 19 & 0x1FL), (int)(shift >> 24 & 0x1FL));
            }
            if ((biomeAccess = this.getBiomeAccessFromView(view)) != null) {
                return this.sampleModifiedColorMaybeLerped(biomeAccess, pos, class_4763::method_30812, class_4763::method_30814, class_1933::method_8377);
            }
            Clime clime = this.sampleClime(pos);
            return class_1933.method_8377((double)clime.temp(), (double)clime.rain());
        }
        return class_1163.method_4962((class_1920)view, (class_2338)pos);
    }

    public int getFoliageColor(class_2680 ignoredState, class_1920 view, class_2338 pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return -12012264;
        }
        if (this.useBiomeColor()) {
            class_4543 biomeAccess = this.getBiomeAccessFromView(view);
            if (biomeAccess != null) {
                return this.sampleModifiedColorMaybeLerped(biomeAccess, pos, class_4763::method_30811, effects -> class_4763.class_5486.field_26426, class_1926::method_8344);
            }
            Clime clime = this.sampleClime(pos);
            return class_1926.method_8344((double)clime.temp(), (double)clime.rain());
        }
        return class_1163.method_4966((class_1920)view, (class_2338)pos);
    }

    public int getWaterColor(class_2680 ignoredState, class_1920 view, class_2338 pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return -1;
        }
        if (this.useWaterColor()) {
            Clime clime = this.sampleClime(pos);
            return this.colormapWater.getColor(clime.temp(), clime.rain());
        }
        return class_1163.method_4961((class_1920)view, (class_2338)pos);
    }

    public int getSugarCaneColor(class_2680 ignoredState, class_1920 view, class_2338 pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return -1;
        }
        if (this.useBiomeColor()) {
            return -1;
        }
        return class_1163.method_4962((class_1920)view, (class_2338)pos);
    }

    public boolean useBiomeColor() {
        return this.climateSampler != null && this.climateSampler.useBiomeColor();
    }

    public boolean useWaterColor() {
        return this.climateSampler != null && this.climateSampler.useWaterColor();
    }

    public ClimateDistribution getClimateDistribution() {
        if (this.climateSampler == null) {
            return ClimateDistribution.DEFAULT;
        }
        return this.climateSampler.getDistribution();
    }

    private int sampleModifiedColorMaybeLerped(class_4543 biomeAccess, class_2338 pos, Function<class_4763, Optional<Integer>> customColorAccessor, Function<class_4763, class_4763.class_5486> grassColorModifierAccessor, ClimateToColorOperator baseColorAccessor) {
        if (this.getClimateDistribution().smoothBorders()) {
            return this.sampleModifiedColorLerped(biomeAccess, pos, customColorAccessor, grassColorModifierAccessor, baseColorAccessor);
        }
        return this.sampleModifiedColor(biomeAccess, pos, customColorAccessor, grassColorModifierAccessor, baseColorAccessor);
    }

    private int sampleModifiedColorLerped(class_4543 biomeAccess, class_2338 pos, Function<class_4763, Optional<Integer>> customColorAccessor, Function<class_4763, class_4763.class_5486> grassColorModifierAccessor, ClimateToColorOperator baseColorAccessor) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    int color = this.sampleModifiedColor(biomeAccess, pos.method_10069(x, y, z), customColorAccessor, grassColorModifierAccessor, baseColorAccessor);
                    r += color >> 16 & 0xFF;
                    g += color >> 8 & 0xFF;
                    b += color & 0xFF;
                }
            }
        }
        return r / 27 << 16 | g / 27 << 8 | b / 27;
    }

    private int sampleModifiedColor(class_4543 biomeAccess, class_2338 pos, Function<class_4763, Optional<Integer>> customColorAccessor, Function<class_4763, class_4763.class_5486> grassColorModifierAccessor, ClimateToColorOperator baseColorAccessor) {
        Clime clime = this.sampleClime(pos);
        int climateColor = baseColorAccessor.apply(clime.temp(), clime.rain());
        class_6880 biomeEntry = biomeAccess.method_22393(pos);
        int finalColor = climateColor;
        if (biomeEntry.method_40220(ModernBetaBiomeTags.HAS_EARLY_RELEASE_SWAMP_COLORS)) {
            finalColor = ((finalColor & 0xFEFEFE) + 0x4E0E4E) / 2;
        } else {
            class_4763.class_5486 grassColorModifier;
            class_1959 biome = (class_1959)biomeEntry.comp_349();
            Optional<Integer> optionalCustomColor = customColorAccessor.apply(biome.method_24377());
            if (optionalCustomColor.isPresent()) {
                int customColor = optionalCustomColor.get();
                class_1959.class_5482 weather = ((AccessorBiome)biome).getWeather();
                float temperature = class_3532.method_15363((float)weather.comp_844(), (float)0.0f, (float)1.0f);
                float downfall = class_3532.method_15363((float)weather.comp_846(), (float)0.0f, (float)1.0f);
                int baseColor = baseColorAccessor.apply(temperature, downfall);
                int modR = (customColor >> 16 & 0xFF) * 255 / (baseColor >> 16 & 0xFF);
                int modG = (customColor >> 8 & 0xFF) * 255 / (baseColor >> 8 & 0xFF);
                int modB = (customColor & 0xFF) * 255 / (baseColor & 0xFF);
                int r = class_3532.method_15340((int)((climateColor >> 16 & 0xFF) * modR / 255), (int)0, (int)255);
                int g = class_3532.method_15340((int)((climateColor >> 8 & 0xFF) * modG / 255), (int)0, (int)255);
                int b = class_3532.method_15340((int)((climateColor & 0xFF) * modB / 255), (int)0, (int)255);
                finalColor = r << 16 | g << 8 | b;
            }
            if ((grassColorModifier = grassColorModifierAccessor.apply(biome.method_24377())) != class_4763.class_5486.field_26426) {
                finalColor = grassColorModifier.method_30823((double)pos.method_10263(), (double)pos.method_10260(), finalColor);
            }
        }
        return finalColor;
    }

    private class_4543 getBiomeAccessFromView(class_1920 view) {
        Optional levelField;
        if (view instanceof class_1937) {
            class_1937 world = (class_1937)view;
            return world.method_22385();
        }
        if (view instanceof class_4538) {
            class_4538 worldView = (class_4538)view;
            return worldView.method_22385();
        }
        if (view instanceof class_853) {
            return ((AccessorChunkRendererRegion)view).getWorld().method_22385();
        }
        try {
            levelField = (Optional)this.viewLevelFieldCache.get((Object)view.getClass());
        }
        catch (ExecutionException e) {
            this.viewLevelFieldCache.put((Object)view.getClass(), Optional.empty());
            e.printStackTrace();
            return null;
        }
        if (levelField.isPresent()) {
            try {
                return ((class_4538)((Field)levelField.get()).get(view)).method_22385();
            }
            catch (IllegalAccessException e) {
                this.viewLevelFieldCache.put((Object)view.getClass(), Optional.empty());
                e.printStackTrace();
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface ClimateToColorOperator {
        public int apply(double var1, double var3);
    }
}

