/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.random.mersenne;

import java.util.Random;
import mod.bluestaggo.modernerbeta.util.random.mersenne.MersenneTwister;

public class MTRandom
extends Random {
    private static final double MAX_UINT_32 = 4.294967296E9;
    private final MersenneTwister mt;

    public MTRandom() {
        this.mt = new MersenneTwister();
    }

    public MTRandom(long seed) {
        this.mt = new MersenneTwister((int)seed);
    }

    @Override
    protected synchronized int next(int bits) {
        return this.mt.genRandInt32() >>> 32 - bits;
    }

    @Override
    public synchronized double nextDouble() {
        return (double)Integer.toUnsignedLong(this.mt.genRandInt32()) / 4.294967296E9;
    }

    @Override
    public synchronized float nextFloat() {
        return (float)((double)Integer.toUnsignedLong(this.mt.genRandInt32()) / 4.294967296E9);
    }

    @Override
    public synchronized int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)(Integer.toUnsignedLong(this.mt.genRandInt32()) % (long)bound);
    }
}

