/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.random.mersenne;

public class MersenneTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int DEFAULT_SEED = 4357;
    private static final int[] MAG_01 = new int[]{0, -1727483681};
    private final int[] mt = new int[624];
    public int mti;
    private int mtiFast;

    public MersenneTwister() {
        this(4357);
    }

    public MersenneTwister(int seed) {
        this.setSeed(seed);
    }

    public synchronized void setSeed(int seed) {
        this.mti = 625;
        this.initFast(seed);
    }

    public synchronized int genRandInt32() {
        if (this.mti == 624) {
            this.mti = 0;
        } else if (this.mti > 624) {
            this.init(5489);
            this.mti = 0;
        }
        if (this.mti >= 227) {
            if (this.mti >= 623) {
                this.mt[623] = MAG_01[this.mt[0] & 1] ^ (this.mt[0] & Integer.MAX_VALUE | this.mt[623] & Integer.MIN_VALUE) >>> 1 ^ this.mt[396];
            } else {
                this.mt[this.mti] = MAG_01[this.mt[this.mti + 1] & 1] ^ (this.mt[this.mti + 1] & Integer.MAX_VALUE | this.mt[this.mti] & Integer.MIN_VALUE) >>> 1 ^ this.mt[this.mti - 227];
            }
        } else {
            this.mt[this.mti] = MAG_01[this.mt[this.mti + 1] & 1] ^ (this.mt[this.mti + 1] & Integer.MAX_VALUE | this.mt[this.mti] & Integer.MIN_VALUE) >>> 1 ^ this.mt[this.mti + 397];
            if (this.mtiFast < 624) {
                this.mt[this.mtiFast] = 1812433253 * (this.mt[this.mtiFast - 1] >>> 30 ^ this.mt[this.mtiFast - 1]) + this.mtiFast;
                ++this.mtiFast;
            }
        }
        int ret = this.mt[this.mti++];
        ret = (ret ^ ret >>> 11) << 7 & 0x9D2C5680 ^ ret ^ ret >>> 11;
        ret = ret << 15 & 0xEFC60000 ^ ret ^ (ret << 15 & 0xEFC60000 ^ ret) >>> 18;
        return ret;
    }

    private synchronized void init(int seed) {
        this.mt[0] = seed;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    public synchronized void initFast(int seed) {
        this.mt[0] = seed;
        this.mtiFast = 1;
        while (this.mtiFast <= 397) {
            this.mt[this.mtiFast] = 1812433253 * (this.mt[this.mtiFast - 1] >>> 30 ^ this.mt[this.mtiFast - 1]) + this.mtiFast;
            ++this.mtiFast;
        }
        this.mti = 624;
    }
}

