/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public record ExtendedBiomeId(class_2960 baseId, String ext, boolean weak) {
    public static final Codec<ExtendedBiomeId> CODEC = Codec.STRING.comapFlatMap(ExtendedBiomeId::validate, ExtendedBiomeId::toString);
    public static final String TRANSLATION_KEY = "createWorld.customize.modern_beta.settings.preview.extended_biome_id";
    public static final ExtendedBiomeId OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9423);
    public static final ExtendedBiomeId DEEP_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9446);
    public static final ExtendedBiomeId PLAINS = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9451);
    public static final ExtendedBiomeId RIVER = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9438);
    public static final ExtendedBiomeId FROZEN_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9435);
    public static final ExtendedBiomeId SNOWY_PLAINS = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_35117);
    public static final ExtendedBiomeId FROZEN_RIVER = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9463);
    public static final ExtendedBiomeId BEACH = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9434);
    public static final ExtendedBiomeId MUSHROOM_ISLAND = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9462);
    public static final ExtendedBiomeId MUSHROOM_SHORE = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9462, "shore");
    public static final ExtendedBiomeId CLIMATE_WARM = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9424, "climate");
    public static final ExtendedBiomeId CLIMATE_TEMPERATE = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9451, "climate");
    public static final ExtendedBiomeId CLIMATE_COOL = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9420, "climate");
    public static final ExtendedBiomeId CLIMATE_SNOWY = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_35117, "climate");
    public static final ExtendedBiomeId RIVER_REGION_A = RIVER.withExt("region_a");
    public static final ExtendedBiomeId RIVER_REGION_B = RIVER.withExt("region_b");
    public static final ExtendedBiomeId RANDOM = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9473, "mutation");
    public static final ExtendedBiomeId WARM_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9408);
    public static final ExtendedBiomeId LUKEWARM_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9441);
    public static final ExtendedBiomeId COLD_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9467);
    public static final ExtendedBiomeId DEEP_LUKEWARM_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9439);
    public static final ExtendedBiomeId DEEP_COLD_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9470);
    public static final ExtendedBiomeId DEEP_FROZEN_OCEAN = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9418);
    public static final ExtendedBiomeId NULL = ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9473, "null");
    public static final List<ExtendedBiomeId> CLIMATE_WARM_RARE = ExtendedBiomeId.rareClimate((class_5321<class_1959>)class_1972.field_9415);
    public static final List<ExtendedBiomeId> CLIMATE_TEMPERATE_RARE = ExtendedBiomeId.rareClimate((class_5321<class_1959>)class_1972.field_9417);
    public static final List<ExtendedBiomeId> CLIMATE_COOL_RARE = ExtendedBiomeId.rareClimate((class_5321<class_1959>)class_1972.field_35119);
    public static final List<ExtendedBiomeId> CLIMATE_SNOWY_RARE = ExtendedBiomeId.rareClimate((class_5321<class_1959>)class_1972.field_9453);

    public static ExtendedBiomeId of(String id) {
        return VersionCompat.getOrThrow(ExtendedBiomeId.validate(id));
    }

    public static ExtendedBiomeId of(String baseId, String ext) {
        boolean weak = false;
        if (baseId.startsWith("~")) {
            weak = true;
            ext = "";
            baseId = baseId.substring(1);
        }
        return new ExtendedBiomeId(VersionCompat.id(baseId), ext, weak);
    }

    public static ExtendedBiomeId of(class_2960 baseId) {
        return new ExtendedBiomeId(baseId, "", false);
    }

    public static ExtendedBiomeId of(class_2960 baseId, String ext) {
        if (ext == null) {
            ext = "";
        }
        return new ExtendedBiomeId(baseId, ext, false);
    }

    public static ExtendedBiomeId ofWeak(class_2960 baseId) {
        return new ExtendedBiomeId(baseId, "", true);
    }

    public static ExtendedBiomeId of(class_5321<class_1959> baseId) {
        return new ExtendedBiomeId(baseId.method_29177(), "", false);
    }

    public static ExtendedBiomeId of(class_5321<class_1959> baseId, String ext) {
        if (ext == null) {
            ext = "";
        }
        return new ExtendedBiomeId(baseId.method_29177(), ext, false);
    }

    public static ExtendedBiomeId ofWeak(class_5321<class_1959> baseId) {
        return new ExtendedBiomeId(baseId.method_29177(), "", true);
    }

    public static List<ExtendedBiomeId> listOf(String ... ids) {
        return Arrays.stream(ids).map(ExtendedBiomeId::of).toList();
    }

    public static Set<ExtendedBiomeId> setOf(String ... ids) {
        return Arrays.stream(ids).map(ExtendedBiomeId::of).collect(Collectors.toSet());
    }

    private static List<ExtendedBiomeId> rareClimate(class_5321<class_1959> baseId) {
        return IntStream.range(0, 15).mapToObj(i -> ExtendedBiomeId.of(baseId, "climate_" + i)).toList();
    }

    public ExtendedBiomeId withExt(String ext) {
        if (ext == null) {
            ext = "";
        }
        return new ExtendedBiomeId(this.baseId, ext, false);
    }

    public ExtendedBiomeId asWeak() {
        return new ExtendedBiomeId(this.baseId, "", true);
    }

    public ExtendedBiomeId asStrong() {
        return new ExtendedBiomeId(this.baseId, this.ext, false);
    }

    public boolean isOf(class_5321<class_1959> biome) {
        return this.baseId.equals((Object)biome.method_29177());
    }

    public boolean isOf(class_2960 biome) {
        return this.baseId.equals((Object)biome);
    }

    public Map.Entry<ExtendedBiomeId, ExtendedBiomeId> mapTo(String id) {
        ExtendedBiomeId next = !id.isEmpty() && id.charAt(0) == '*' ? this.withExt(id.substring(1)) : ExtendedBiomeId.of(id);
        return Map.entry(this, next);
    }

    @Override
    @NotNull
    public String toString() {
        Object name = this.baseId.toString();
        if (this.ext != null && !this.ext.isEmpty()) {
            name = (String)name + "*" + this.ext;
        }
        if (this.weak) {
            name = "~" + (String)name;
        }
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedBiomeId that = (ExtendedBiomeId)o;
        return Objects.equals(this.baseId, that.baseId) && (this.weak || that.weak || Objects.equals(this.ext, that.ext));
    }

    @Override
    public int hashCode() {
        return this.baseId.hashCode();
    }

    public static DataResult<ExtendedBiomeId> validate(String string) {
        int asterisk;
        String ext;
        boolean weak;
        boolean bl = weak = !string.isEmpty() && string.charAt(0) == '~';
        if (weak) {
            string = string.substring(1);
        }
        String string2 = ext = (asterisk = string.indexOf(42)) == -1 ? "" : string.substring(asterisk + 1);
        if (asterisk != -1) {
            string = string.substring(0, asterisk);
        }
        return class_2960.method_29186((String)string).flatMap(id -> DataResult.success((Object)new ExtendedBiomeId((class_2960)id, ext, weak)));
    }
}

