/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.intlayers;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_4540;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public abstract class IntLayer {
    private final transient long seed;
    private transient long saltedSeed;
    private transient ThreadLocal<LayerRandom> random;
    private final transient ThreadLocal<Long2IntLinkedOpenHashMap> cache = ThreadLocal.withInitial(() -> {
        Long2IntLinkedOpenHashMap map = new Long2IntLinkedOpenHashMap(25);
        map.defaultReturnValue(Integer.MIN_VALUE);
        return map;
    });

    public IntLayer(long seed) {
        this.seed = seed;
        long saltedSeed = seed;
        for (int i = 0; i < 3; ++i) {
            saltedSeed = class_4540.method_22372((long)saltedSeed, (long)seed);
        }
        this.saltedSeed = saltedSeed;
    }

    public abstract int generate(class_7871<class_1959> var1, int var2, int var3);

    public int sample(class_7871<class_1959> biomeRegistry, int x, int z) {
        long coord;
        Long2IntLinkedOpenHashMap cache = this.cache.get();
        int value = cache.get(coord = class_1923.method_8331((int)x, (int)z));
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        value = this.generate(biomeRegistry, x, z);
        if (cache.size() == 25) {
            cache.removeFirstInt();
        }
        cache.put(coord, value);
        return value;
    }

    public void init(long worldSeed) {
        this.saltedSeed = this.seed;
        for (int i = 0; i < 3; ++i) {
            this.saltedSeed = class_4540.method_22372((long)this.saltedSeed, (long)this.seed);
        }
        long preWorldSeed = this.saltedSeed;
        this.saltedSeed = worldSeed;
        for (int i = 0; i < 3; ++i) {
            this.saltedSeed = class_4540.method_22372((long)this.saltedSeed, (long)preWorldSeed);
        }
        this.random = ThreadLocal.withInitial(() -> new LayerRandom(this.saltedSeed));
    }

    protected final LayerRandom getRandom(long x, long z) {
        LayerRandom random = this.random.get();
        random.init(x, z);
        return random;
    }

    protected static class_1959 getBiomeFromLayer(class_7871<class_1959> biomeRegistry, Layer layer, int x, int z) {
        ExtendedBiomeId extendedBiomeId = layer.sample(x, z);
        return biomeRegistry.method_46746(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)extendedBiomeId.baseId())).map(class_6880::comp_349).orElse(null);
    }
}

