/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SingleParentLayer;

public class ApplyOceanClimateLayer
extends SingleParentLayer {
    public static final MapCodec<ApplyOceanClimateLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> ApplyOceanClimateLayer.fillSingleParentLayerFields(instance).and(instance.group((App)Codec.STRING.fieldOf("oceanClimate").forGetter(layer -> layer.oceanClimate), (App)Codec.BOOL.fieldOf("applyCoasts").orElse((Object)true).forGetter(layer -> layer.applyCoasts))).apply((Applicative)instance, ApplyOceanClimateLayer::new));
    private static final Set<ExtendedBiomeId> BASE_OCEANS = Set.of(ExtendedBiomeId.OCEAN, ExtendedBiomeId.DEEP_OCEAN);
    private static final Map<ExtendedBiomeId, ExtendedBiomeId> DEEP_MAP = Map.of(ExtendedBiomeId.WARM_OCEAN, ExtendedBiomeId.WARM_OCEAN.withExt("deep"), ExtendedBiomeId.LUKEWARM_OCEAN, ExtendedBiomeId.DEEP_LUKEWARM_OCEAN, ExtendedBiomeId.OCEAN, ExtendedBiomeId.DEEP_OCEAN, ExtendedBiomeId.COLD_OCEAN, ExtendedBiomeId.DEEP_COLD_OCEAN, ExtendedBiomeId.FROZEN_OCEAN, ExtendedBiomeId.DEEP_FROZEN_OCEAN);
    private final String oceanClimate;
    private final boolean applyCoasts;
    private transient Layer oceanClimateLayer;

    public ApplyOceanClimateLayer(String id, long seed, String parent, String oceanClimate, boolean applyCoasts) {
        super(id, seed, parent);
        this.oceanClimate = oceanClimate;
        this.applyCoasts = applyCoasts;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.APPLY_OCEAN_CLIMATE;
    }

    @Override
    public void configure(Function<String, Layer> layerMap) {
        super.configure(layerMap);
        this.oceanClimateLayer = layerMap.apply(this.oceanClimate);
    }

    @Override
    protected List<Layer> getParents() {
        return List.of(this.parentLayer, this.oceanClimateLayer);
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        boolean isWarm;
        ExtendedBiomeId base = this.parentLayer.sample(x, z);
        if (!BASE_OCEANS.contains(base)) {
            return base;
        }
        ExtendedBiomeId ocean = this.oceanClimateLayer.sample(x, z);
        if (this.applyCoasts && ((isWarm = ExtendedBiomeId.WARM_OCEAN.equals(ocean)) || ExtendedBiomeId.FROZEN_OCEAN.equals(ocean))) {
            for (int ox = -8; ox <= 8; ox += 4) {
                for (int oz = -8; oz <= 8; oz += 4) {
                    ExtendedBiomeId nearBiome = this.parentLayer.sample(x + ox, z + oz);
                    if (BASE_OCEANS.contains(nearBiome)) continue;
                    return isWarm ? ExtendedBiomeId.LUKEWARM_OCEAN : ExtendedBiomeId.COLD_OCEAN;
                }
            }
        }
        if (ExtendedBiomeId.DEEP_OCEAN.equals(base)) {
            ocean = DEEP_MAP.getOrDefault(ocean, ocean);
        }
        return ocean;
    }
}

