/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk.provider;

import java.util.Random;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceBlocks;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.spawn.SpawnLocatorBeta;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_6350;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7138;

public class ChunkProviderInfdev415
extends ChunkProviderNoise {
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise beachOctaveNoise;
    private final PerlinOctaveNoise surfaceOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;

    public ChunkProviderInfdev415(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        this.beachOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        this.surfaceOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        new PerlinOctaveNoise(this.random, 5, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 5, true);
    }

    @Override
    public SpawnLocator getSpawnLocator() {
        return new SpawnLocatorBeta(this, this.beachOctaveNoise, new Random(this.seed));
    }

    @Override
    public void provideSurface(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
        double scale = 0.03125;
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        Random bedrockRand = this.createSurfaceRandom(chunkX, chunkZ);
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_6350 aquiferSampler = this.getAquiferSampler(chunk, noiseConfig);
        ChunkHeightmap heightmapChunk = this.getChunkHeightmap(chunkX, chunkZ);
        SimpleNoisePos noisePos = new SimpleNoisePos();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = chunk.method_12032(class_2902.class_2903.field_13195).method_12603(localX, localZ) - 1;
                int surfaceMinY = this.hasNoisePostProcessor() ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) - 8 : this.worldMinY;
                boolean genSandBeach = this.beachOctaveNoise.sample((double)x * scale, (double)z * scale, 0.0) + rand.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.beachOctaveNoise.sample((double)z * scale, 109.0134, (double)x * scale) + rand.nextDouble() * 0.2 > 3.0;
                double surfaceNoise = this.surfaceOctaveNoise.sampleXY((double)x * scale * 2.0, (double)z * scale * 2.0);
                int surfaceDepth = (int)(surfaceNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int runDepth = -1;
                class_6880<class_1959> biome = biomeSource.getBiomeForSurfaceGen(region, (class_2338)pos.method_10103(x, surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                class_2680 topBlock = surfaceConfig.normal().topBlock();
                class_2680 fillerBlock = surfaceConfig.normal().fillerBlock();
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    pos.method_10103(localX, y, localZ);
                    class_2680 blockState = chunk.method_8320((class_2338)pos);
                    if (y <= this.bedrockFloor + bedrockRand.nextInt(5)) {
                        VersionCompat.setBlockState(chunk, (class_2338)pos, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y < surfaceMinY) continue;
                    if (blockState.method_26215()) {
                        runDepth = -1;
                        continue;
                    }
                    if (!blockState.method_27852(this.defaultBlock.method_26204())) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        } else if (y >= this.seaLevel - 4 && y <= this.seaLevel + 1) {
                            topBlock = surfaceConfig.normal().topBlock();
                            fillerBlock = surfaceConfig.normal().fillerBlock();
                            if (genGravelBeach) {
                                topBlock = surfaceConfig.beachGravel().topBlock();
                                fillerBlock = surfaceConfig.beachGravel().fillerBlock();
                            }
                            if (genSandBeach) {
                                topBlock = surfaceConfig.beachSand().topBlock();
                                fillerBlock = surfaceConfig.beachSand().fillerBlock();
                            }
                        }
                        runDepth = surfaceDepth;
                        if (y < this.seaLevel && topBlock.method_26215()) {
                            class_2680 fluidBlock = aquiferSampler.method_38317((class_6910.class_6912)noisePos.set(x, y, z), 0.0);
                            boolean isAir = fluidBlock == null;
                            topBlock = isAir ? BlockStates.AIR : fluidBlock;
                            this.scheduleFluidTick(chunk, aquiferSampler, (class_2338)pos, topBlock);
                        }
                        blockState = y >= this.seaLevel - 1 || y < this.seaLevel - 1 && chunk.method_8320(pos.method_10084()).method_26215() ? topBlock : fillerBlock;
                        VersionCompat.setBlockState(chunk, (class_2338)pos, blockState);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    --runDepth;
                    VersionCompat.setBlockState(chunk, (class_2338)pos, fillerBlock);
                }
            }
        }
    }

    @Override
    public void provideSurfaceExtra(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
        double scale = 0.03125;
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        class_2338.class_2339 pos = new class_2338.class_2339();
        ChunkHeightmap heightmapChunk = this.hasNoisePostProcessor() ? this.getChunkHeightmap(chunkX, chunkZ) : null;
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                SurfaceBlocks beach;
                pos.method_10103(localX, 0, localZ);
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = heightmapChunk != null ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) : chunk.method_12032(class_2902.class_2903.field_13195).method_12603(localX, localZ);
                boolean genSandBeach = this.beachOctaveNoise.sample((double)x * scale, (double)z * scale, 0.0) + rand.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.beachOctaveNoise.sample((double)z * scale, 109.0134, (double)x * scale) + rand.nextDouble() * 0.2 > 3.0;
                int surfaceDepth = (int)(this.surfaceOctaveNoise.sampleXY((double)x * scale * 2.0, (double)z * scale * 2.0) / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                class_6880<class_1959> biome = biomeSource.getBiomeForSurfaceGen(region, (class_2338)pos.method_10103(x, --surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                int y = surfaceTopY;
                pos.method_33098(y);
                if (!this.isBlockSuitableForSurface(chunk.method_8320((class_2338)pos))) continue;
                if (surfaceDepth <= 0) {
                    VersionCompat.setBlockState(chunk, (class_2338)pos, y < this.seaLevel ? this.defaultFluid : BlockStates.AIR);
                    pos.method_33098(--y);
                    while (this.isBlockSuitableForSurface(chunk.method_8320((class_2338)pos))) {
                        VersionCompat.setBlockState(chunk, (class_2338)pos, this.defaultBlock);
                        pos.method_33098(--y);
                    }
                    continue;
                }
                if (surfaceTopY < this.seaLevel - 4 || surfaceTopY >= this.seaLevel + 1) continue;
                SurfaceBlocks surfaceBlocks = genSandBeach ? surfaceConfig.beachSand() : (beach = genGravelBeach ? surfaceConfig.beachGravel() : null);
                if (beach == null) continue;
                if (beach.topBlock().method_26215() && y < this.seaLevel) {
                    VersionCompat.setBlockState(chunk, (class_2338)pos, this.defaultFluid);
                } else {
                    VersionCompat.setBlockState(chunk, (class_2338)pos, beach.topBlock());
                }
                pos.method_33098(--y);
                while (this.isBlockSuitableForSurface(chunk.method_8320((class_2338)pos))) {
                    VersionCompat.setBlockState(chunk, (class_2338)pos, beach.fillerBlock());
                    pos.method_33098(--y);
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] primaryBuffer, double[] heightmapBuffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double islandOffset = this.getIslandOffset(noiseX, noiseZ);
        double coordinateScale = this.noiseScale.coordinate();
        double heightScale = this.noiseScale.height();
        double mainNoiseScaleX = this.noiseScale.mainNoiseX();
        double mainNoiseScaleY = this.noiseScale.mainNoiseY();
        double mainNoiseScaleZ = this.noiseScale.mainNoiseZ();
        double lowerLimitScale = this.noiseScale.lowerLimit();
        double upperLimitScale = this.noiseScale.upperLimit();
        for (int y = 0; y < primaryBuffer.length; ++y) {
            double density;
            int noiseY = y + this.noiseMinY;
            double densityOffset = this.getOffset(noiseY);
            double mainNoiseVal = this.mainOctaveNoise.sample((double)noiseX * coordinateScale / mainNoiseScaleX, (double)noiseY * coordinateScale / mainNoiseScaleY, (double)noiseZ * coordinateScale / mainNoiseScaleZ) / 2.0;
            if (mainNoiseVal < -1.0) {
                density = this.minLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / lowerLimitScale;
                density -= densityOffset;
                density += islandOffset;
                density = this.clampNoise(density);
            } else if (mainNoiseVal > 1.0) {
                density = this.maxLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / upperLimitScale;
                density -= densityOffset;
                density += islandOffset;
                density = this.clampNoise(density);
            } else {
                double minLimitVal = this.minLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / lowerLimitScale;
                double maxLimitVal = this.maxLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / upperLimitScale;
                minLimitVal -= densityOffset;
                maxLimitVal -= densityOffset;
                minLimitVal += islandOffset;
                maxLimitVal += islandOffset;
                minLimitVal = this.clampNoise(minLimitVal);
                maxLimitVal = this.clampNoise(maxLimitVal);
                double delta = (mainNoiseVal + 1.0) / 2.0;
                density = minLimitVal + (maxLimitVal - minLimitVal) * delta;
            }
            double heightmapDensity = density;
            density = this.sampleNoisePostProcessor(density, noiseX, noiseY, noiseZ);
            density = this.applySlides(density, y);
            heightmapDensity = this.applySlides(heightmapDensity, y);
            primaryBuffer[y] = density;
            heightmapBuffer[y] = heightmapDensity;
        }
    }

    @Override
    protected PerlinOctaveNoise getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    private double clampNoise(double density) {
        if (this.hasNoisePostProcessor()) {
            return density;
        }
        return class_3532.method_15350((double)density, (double)-10.0, (double)10.0);
    }

    private double getOffset(int noiseY) {
        double offset = (double)(noiseY * this.noiseResolutionVertical) - (double)this.seaLevel;
        if (offset < 0.0) {
            offset *= 3.0;
        }
        return offset;
    }
}

