/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.feature.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.feature.ModernBetaTrunkPlacers;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class BetaLargeOakTrunkPlacer
extends class_5141 {
    public static final MapCodec<BetaLargeOakTrunkPlacer> CODEC = VersionCompat.createMaybeMapCodec(instance -> BetaLargeOakTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and((App)Codec.BOOL.fieldOf("rotate_logs").forGetter(p -> p.rotateLogs)).apply((Applicative)instance, BetaLargeOakTrunkPlacer::new));
    private final boolean rotateLogs;
    private static final double HEIGHT_SCALE = 0.618;
    private static final double CLUSTER_DENSITY = 1.382;
    private static final double BRANCH_SLOPE = 0.381;
    private static final double BRANCH_LENGTH = 0.328;

    public BetaLargeOakTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, boolean rotateLogs) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.rotateLogs = rotateLogs;
    }

    protected class_5142<?> method_28903() {
        return ModernBetaTrunkPlacers.BETA_LARGE_OAK_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 basePos, class_4643 config) {
        int foliageHeight = 5;
        double branchDensity = 1.0;
        BetaLargeOakTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)basePos.method_10074(), (class_4643)config);
        int treeHeight = class_3532.method_15357((double)((double)height * 0.618));
        if (treeHeight >= height) {
            treeHeight = height - 1;
        }
        int foliageBlobCount = Math.min(1, (int)(1.382 + Math.pow(branchDensity * (double)height / 13.0, 2.0)));
        int foliageBaseY = basePos.method_10264() + height - foliageHeight;
        int treeTopY = basePos.method_10264() + treeHeight;
        int treeRelY = foliageBaseY - basePos.method_10264();
        ArrayList list = Lists.newArrayList();
        list.add(new BranchPosition(basePos.method_33096(foliageBaseY), treeTopY));
        --foliageBaseY;
        while (treeRelY >= 0) {
            float foliageDistance = this.getFoliageDistance(treeRelY, height);
            if (foliageDistance >= 0.0f) {
                for (int currentBlobCount = 0; currentBlobCount < foliageBlobCount; ++currentBlobCount) {
                    class_2338 endPos;
                    int randZ;
                    double randAngle;
                    double randRadius = branchDensity * (double)foliageDistance * ((double)random.method_43057() + 0.328);
                    int randX = class_3532.method_15357((double)(randRadius * Math.sin(randAngle = (double)(random.method_43057() * 2.0f) * Math.PI) + 0.5));
                    class_2338 startPos = basePos.method_10069(randX, treeRelY - 1, randZ = class_3532.method_15357((double)(randRadius * Math.cos(randAngle) + 0.5)));
                    if (!this.makeOrCheckBranch(world, replacer, random, startPos, endPos = startPos.method_10086(foliageHeight), false, config)) continue;
                    int xLength = Math.abs(basePos.method_10263() - startPos.method_10263());
                    int zLength = Math.abs(basePos.method_10260() - startPos.method_10260());
                    double distance = (double)startPos.method_10264() - Math.sqrt(xLength * xLength + zLength * zLength) * 0.381;
                    int endY = distance > (double)treeTopY ? treeTopY : (int)distance;
                    endPos = new class_2338(basePos.method_10263(), endY, basePos.method_10260());
                    if (!this.makeOrCheckBranch(world, replacer, random, endPos, startPos, false, config)) continue;
                    list.add(new BranchPosition(startPos, endPos.method_10264()));
                }
            }
            --foliageBaseY;
            --treeRelY;
        }
        this.makeOrCheckBranch(world, replacer, random, basePos, basePos.method_10086(treeHeight), true, config);
        this.makeBranches(world, replacer, random, height, basePos, list, config);
        ArrayList nodes = Lists.newArrayList();
        for (BranchPosition branchPosition : list) {
            nodes.add(branchPosition.node);
        }
        return nodes;
    }

    public int method_26993(class_5819 random) {
        return this.field_23760 + random.method_43048(this.field_23761 + 1);
    }

    private boolean makeOrCheckBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_2338 branchPos, boolean make, class_4643 config) {
        if (!make && Objects.equals(startPos, branchPos)) {
            return true;
        }
        class_2338 startMinus = branchPos.method_10069(-startPos.method_10263(), -startPos.method_10264(), -startPos.method_10260());
        int longestSide = this.getLongestSide(startMinus);
        float xM = (float)startMinus.method_10263() / (float)longestSide;
        float yM = (float)startMinus.method_10264() / (float)longestSide;
        float zM = (float)startMinus.method_10260() / (float)longestSide;
        for (int i = 0; i <= longestSide; ++i) {
            class_2338 offset = startPos.method_10069(class_3532.method_15375((float)((float)i * xM)), class_3532.method_15375((float)((float)i * yM)), class_3532.method_15375((float)((float)i * zM)));
            if (make) {
                this.method_27402(world, replacer, random, offset, config, state -> this.rotateLogs ? (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)this.getLogAxis(startPos, offset)) : state);
                continue;
            }
            if (this.method_43198(world, offset)) continue;
            return false;
        }
        return true;
    }

    private int getLongestSide(class_2338 offset) {
        int x = class_3532.method_15382((int)offset.method_10263());
        int y = class_3532.method_15382((int)offset.method_10264());
        int z = class_3532.method_15382((int)offset.method_10260());
        return Math.max(x, Math.max(y, z));
    }

    private class_2350.class_2351 getLogAxis(class_2338 branchStart, class_2338 branchEnd) {
        int distanceZ;
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        int distanceX = Math.abs(branchEnd.method_10263() - branchStart.method_10263());
        int maxDistance = Math.max(distanceX, distanceZ = Math.abs(branchEnd.method_10260() - branchStart.method_10260()));
        if (maxDistance > 0) {
            axis = distanceX == maxDistance ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        }
        return axis;
    }

    private boolean isHighEnough(int treeHeight, int height) {
        return (double)height >= (double)treeHeight * 0.2;
    }

    private void makeBranches(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int treeHeight, class_2338 startPos, List<BranchPosition> branchPositions, class_4643 config) {
        for (BranchPosition branchPosition : branchPositions) {
            int endY = branchPosition.endY;
            class_2338 blockPos = new class_2338(startPos.method_10263(), endY, startPos.method_10260());
            if (blockPos.equals((Object)branchPosition.node.method_27388()) || !this.isHighEnough(treeHeight, endY - startPos.method_10264())) continue;
            this.makeOrCheckBranch(world, replacer, random, blockPos, branchPosition.node.method_27388(), true, config);
        }
    }

    private float getFoliageDistance(int treeRelY, int treeHeight) {
        if ((float)treeRelY < (float)treeHeight * 0.3f) {
            return -1.618f;
        }
        float radius = (float)treeHeight / 2.0f;
        float distFromRadius = radius - (float)treeRelY;
        float distance = class_3532.method_15355((float)(radius * radius - distFromRadius * distFromRadius));
        if (distFromRadius == 0.0f) {
            distance = radius;
        } else if (Math.abs(distFromRadius) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    record BranchPosition(class_4647.class_5208 node, int endY) {
        public BranchPosition(class_2338 pos, int endY) {
            this(new class_4647.class_5208(pos, 0, false), endY);
        }
    }
}

