/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.protocoltranslator.translator;

import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viafabricplus.protocoltranslator.protocol.ViaFabricPlusProtocol;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.Direction;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_12to1_12_1.packet.ClientboundPackets1_12_1;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import net.raphimc.vialegacy.protocol.beta.b1_8_0_1tor1_0_0_1.types.Typesb1_8_0_1;
import net.raphimc.vialegacy.protocol.release.r1_2_4_5tor1_3_1_2.types.Types1_2_4;
import net.raphimc.vialegacy.protocol.release.r1_4_2tor1_4_4_5.types.Types1_4_2;
import net.raphimc.vialegacy.protocol.release.r1_7_6_10tor1_8.types.Types1_7_6;

public final class ItemTranslator {
    public static Item mcToVia(class_1799 stack, ProtocolVersion targetVersion) {
        UserConnection connection = ProtocolTranslator.createDummyUserConnection(ProtocolTranslator.NATIVE_VERSION, targetVersion);
        try {
            class_9129 buf = new class_9129(Unpooled.buffer(), (class_5455)class_310.method_1551().method_1562().method_29091());
            buf.method_52998(0);
            class_1799.field_58141.encode((Object)buf, (Object)stack);
            PacketWrapper setCreativeModeSlot = PacketWrapper.create((PacketType)ViaFabricPlusProtocol.INSTANCE.getSetCreativeModeSlot(), (ByteBuf)buf, (UserConnection)connection);
            connection.getProtocolInfo().getPipeline().transform(Direction.SERVERBOUND, State.PLAY, setCreativeModeSlot);
            setCreativeModeSlot.read((Type)Types.SHORT);
            return (Item)setCreativeModeSlot.read(ItemTranslator.getServerboundItemType(targetVersion));
        }
        catch (Throwable t) {
            ViaFabricPlusImpl.INSTANCE.getLogger().error("Error converting native item stack to ViaVersion {} item stack", (Object)targetVersion, (Object)t);
            return null;
        }
    }

    public static class_1799 viaToMc(Item item, ProtocolVersion sourceVersion) {
        UserConnection connection = ProtocolTranslator.createDummyUserConnection(ProtocolTranslator.NATIVE_VERSION, sourceVersion);
        try {
            Protocol sourceProtocol = connection.getProtocolInfo().getPipeline().reversedPipes().stream().filter(p -> !p.isBaseProtocol()).findFirst().orElseThrow();
            PacketWrapper containerSetSlot = PacketWrapper.create((PacketType)sourceProtocol.getPacketTypesProvider().unmappedClientboundType(State.PLAY, ClientboundPackets1_12_1.CONTAINER_SET_SLOT.getName()), (UserConnection)connection);
            if (sourceVersion.newerThanOrEqualTo(ProtocolVersion.v1_8)) {
                containerSetSlot.write((Type)Types.UNSIGNED_BYTE, (Object)0);
            } else {
                containerSetSlot.write((Type)Types.BYTE, (Object)0);
            }
            containerSetSlot.write((Type)Types.SHORT, (Object)0);
            containerSetSlot.write(ItemTranslator.getClientboundItemType(sourceVersion), (Object)(item != null ? item.copy() : null));
            containerSetSlot.resetReader();
            containerSetSlot.user().getProtocolInfo().getPipeline().transform(Direction.CLIENTBOUND, State.PLAY, containerSetSlot);
            class_9129 buf = new class_9129(Unpooled.buffer(), (class_5455)class_310.method_1551().method_1562().method_29091());
            containerSetSlot.setPacketType(null);
            containerSetSlot.writeToBuffer((ByteBuf)buf);
            buf.readUnsignedByte();
            buf.method_10816();
            buf.readShort();
            return (class_1799)class_1799.field_49268.decode((Object)buf);
        }
        catch (Throwable t) {
            ViaFabricPlusImpl.INSTANCE.getLogger().error("Error converting ViaVersion {} item to native item stack", (Object)sourceVersion, (Object)t);
            return class_1799.field_8037;
        }
    }

    public static Type<Item> getServerboundItemType(ProtocolVersion targetVersion) {
        if (targetVersion.olderThanOrEqualTo(LegacyProtocolVersion.b1_8tob1_8_1)) {
            return Typesb1_8_0_1.CREATIVE_ITEM;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_21_4)) {
            return ItemTranslator.getClientboundItemType(targetVersion);
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_21_5)) {
            return VersionedTypes.V1_21_5.lengthPrefixedItem;
        }
        return VersionedTypes.V1_21_6.lengthPrefixedItem;
    }

    public static Type<Item> getClientboundItemType(ProtocolVersion targetVersion) {
        if (targetVersion.olderThanOrEqualTo(LegacyProtocolVersion.b1_8tob1_8_1)) {
            return Types1_4_2.NBTLESS_ITEM;
        }
        if (targetVersion.olderThanOrEqualTo(LegacyProtocolVersion.r1_2_4tor1_2_5)) {
            return Types1_2_4.NBT_ITEM;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_7_6)) {
            return Types1_7_6.ITEM;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_12_2)) {
            return Types.ITEM1_8;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_13_1)) {
            return Types.ITEM1_13;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_20)) {
            return Types.ITEM1_13_2;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_3)) {
            return Types.ITEM1_20_2;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_5)) {
            return VersionedTypes.V1_20_5.item;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_21)) {
            return VersionedTypes.V1_21.item;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_21_2)) {
            return VersionedTypes.V1_21_2.item;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_21_4)) {
            return VersionedTypes.V1_21_4.item;
        }
        if (targetVersion.olderThanOrEqualTo(ProtocolVersion.v1_21_5)) {
            return VersionedTypes.V1_21_5.item;
        }
        return VersionedTypes.V1_21_6.item;
    }
}

