/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.freecam;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zergatul.freecam.FreeCamConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigRepository {
    public static final ConfigRepository instance = new ConfigRepository();
    private static final String FILE = "zergatul.freecam.json";
    private final Logger logger = LogManager.getLogger(ConfigRepository.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private ConfigRepository() {
    }

    public void save(FreeCamConfig config) {
        File file = this.getFile();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            this.gson.toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            this.logger.warn("Cannot write config", (Throwable)e);
        }
    }

    public FreeCamConfig load() {
        File file = this.getFile();
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                FreeCamConfig config = (FreeCamConfig)this.gson.fromJson((Reader)reader, FreeCamConfig.class);
                config.clamp();
                reader.close();
                return config;
            }
            catch (Exception e) {
                this.logger.warn("Cannot read config", (Throwable)e);
            }
        }
        return new FreeCamConfig();
    }

    private File getFile() {
        File configDir = new File(class_310.method_1551().field_1697, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        return new File(configDir.getPath(), FILE);
    }
}

