/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.freecam;

import com.zergatul.freecam.ConfigRepository;
import com.zergatul.freecam.FreeCamConfig;
import com.zergatul.freecam.FreeCamPath;
import com.zergatul.freecam.KeyBindings;
import com.zergatul.freecam.ModApiWrapper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_10185;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_744;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FreeCam {
    public static final FreeCam instance = new FreeCam();
    private static final int REMEMBER_STATE_DELAY_MS = 400;
    private final class_310 mc = class_310.method_1551();
    private final Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vector3f forwards = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);
    private final FreeCamPath path = new FreeCamPath(this);
    private final FreeCamConfig config = ConfigRepository.instance.load();
    private boolean active;
    private class_5498 oldCameraType;
    private class_744 playerInput;
    private class_744 freecamInput;
    private double x;
    private double y;
    private double z;
    private float yRot;
    private float xRot;
    private double forwardVelocity;
    private double leftVelocity;
    private double upVelocity;
    private long lastTime;
    private boolean freecamHitResultPicking;
    private boolean cameraLock;
    private boolean eyeLock;
    private boolean followCamera;
    private double followDeltaX;
    private double followDeltaY;
    private double followDeltaZ;
    private boolean gameRendererPicking;
    private boolean moveAlongPath;
    private long pathStartTime;
    private long dontMoveFreeCamBefore;

    private FreeCam() {
    }

    public boolean isActive() {
        return this.active;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public class_243 getPos() {
        return new class_243(this.x, this.y, this.z);
    }

    public class_2338 getBlockPos() {
        return new class_2338((int)this.x, (int)this.y, (int)this.z);
    }

    public FreeCamConfig getConfig() {
        return this.config;
    }

    public FreeCamPath getPath() {
        return this.path;
    }

    public void toggle() {
        if (this.active) {
            this.disable();
        } else {
            this.enable();
        }
    }

    public void toggleCameraLock() {
        assert (this.mc.field_1724 != null);
        if (this.active && !this.followCamera) {
            this.cameraLock = !this.cameraLock;
            this.mc.field_1724.field_3913 = this.cameraLock ? this.playerInput : this.freecamInput;
        }
    }

    public void toggleEyeLock() {
        if (this.active && !this.followCamera) {
            this.eyeLock = !this.eyeLock;
        }
    }

    public void toggleFollowCamera() {
        assert (this.mc.field_1724 != null);
        if (this.active) {
            boolean bl = this.followCamera = !this.followCamera;
            if (this.followCamera) {
                this.mc.field_1724.field_3913 = this.playerInput;
                this.cameraLock = false;
                this.eyeLock = false;
                class_1297 entity = this.mc.method_1560();
                if (entity == null) {
                    return;
                }
                class_243 pos = entity.method_33571();
                this.followDeltaX = this.x - pos.field_1352;
                this.followDeltaY = this.y - pos.field_1351;
                this.followDeltaZ = this.z - pos.field_1350;
            } else {
                this.mc.field_1724.field_3913 = this.freecamInput;
            }
        }
    }

    public void enable() {
        if (this.active) {
            return;
        }
        class_1297 entity = this.mc.method_1560();
        if (entity == null) {
            return;
        }
        this.active = true;
        this.cameraLock = false;
        this.eyeLock = false;
        this.followCamera = false;
        this.oldCameraType = this.mc.field_1690.method_31044();
        this.playerInput = this.mc.field_1724.field_3913;
        this.mc.field_1724.field_3913 = this.freecamInput = this.createFreeCamInput(this.playerInput);
        this.mc.field_1690.method_31043(class_5498.field_26665);
        if (this.oldCameraType.method_31034() != this.mc.field_1690.method_31044().method_31034()) {
            this.mc.field_1773.method_3167(this.mc.field_1690.method_31044().method_31034() ? this.mc.method_1560() : null);
        }
        if (this.config.rememberInputState) {
            this.dontMoveFreeCamBefore = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(400L);
        }
        float partialTicks = this.mc.method_61966().method_60637(true);
        class_243 pos = entity.method_5836(partialTicks);
        this.x = pos.field_1352;
        this.y = pos.field_1351;
        this.z = pos.field_1350;
        this.yRot = entity.method_5705(partialTicks);
        this.xRot = entity.method_5695(partialTicks);
        this.calculateVectors();
        double distance = -2.0;
        this.x += (double)this.forwards.x() * distance;
        this.y += (double)this.forwards.y() * distance;
        this.z += (double)this.forwards.z() * distance;
        this.forwardVelocity = 0.0;
        this.leftVelocity = 0.0;
        this.upVelocity = 0.0;
        this.lastTime = 0L;
    }

    public void disable() {
        assert (this.mc.field_1724 != null);
        if (!this.active) {
            return;
        }
        this.active = false;
        class_5498 cameraType = this.mc.field_1690.method_31044();
        this.mc.field_1690.method_31043(this.oldCameraType);
        this.mc.field_1724.field_3913 = this.playerInput;
        if (cameraType.method_31034() != this.mc.field_1690.method_31044().method_31034()) {
            this.mc.field_1773.method_3167(this.mc.field_1690.method_31044().method_31034() ? this.mc.method_1560() : null);
        }
        this.oldCameraType = null;
    }

    public void onHandleKeyBindings() {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.mc.field_1755 != null) {
            return;
        }
        while (KeyBindings.toggleFreeCam.method_1436()) {
            this.toggle();
        }
        while (KeyBindings.toggleCameraLock.method_1436()) {
            this.toggleCameraLock();
        }
        while (KeyBindings.toggleEyeLock.method_1436()) {
            this.toggleEyeLock();
        }
        while (KeyBindings.toggleFollowCam.method_1436()) {
            this.toggleFollowCamera();
        }
        while (KeyBindings.startPath.method_1436()) {
            this.startPath();
        }
    }

    public boolean onPlayerTurn(double yRot, double xRot) {
        if (this.active && !this.cameraLock && !this.followCamera) {
            if (!this.eyeLock && !this.moveAlongPath) {
                this.xRot += (float)xRot * 0.15f;
                this.yRot += (float)yRot * 0.15f;
                this.xRot = class_3532.method_15363((float)this.xRot, (float)-90.0f, (float)90.0f);
                this.calculateVectors();
            }
            return false;
        }
        return true;
    }

    public boolean onRenderCrosshairModifyIsFirstPerson(boolean value) {
        if (this.active) {
            return !this.cameraLock && !this.eyeLock && !this.followCamera && this.config.target;
        }
        return value;
    }

    public boolean onRenderItemInHandIsFirstPerson(class_5498 cameraType) {
        if (this.active && this.config.renderHands && !this.cameraLock && !this.eyeLock && !this.followCamera) {
            return true;
        }
        return cameraType.method_31034();
    }

    public boolean shouldShowMyName() {
        return this.active && this.config.showMyName;
    }

    public void onRenderTickStart(class_9779 delta) {
        if (!this.active) {
            return;
        }
        if (this.lastTime == 0L) {
            this.lastTime = System.nanoTime();
            return;
        }
        long currTime = System.nanoTime();
        float frameTime = (float)(currTime - this.lastTime) / 1.0E9f;
        this.lastTime = currTime;
        if (this.moveAlongPath) {
            FreeCamPath.Entry entry = this.path.interpolate((double)(currTime - this.pathStartTime) / 1000000.0);
            if (entry == null) {
                this.moveAlongPath = false;
            } else {
                this.x = entry.position().field_1352;
                this.y = entry.position().field_1351;
                this.z = entry.position().field_1350;
                this.xRot = (float)entry.xRot();
                this.yRot = (float)entry.yRot();
            }
        } else if (this.followCamera) {
            class_1297 entity = this.mc.method_1560();
            if (entity != null) {
                class_243 pos = entity.method_5836(delta.method_60637(true));
                this.x = pos.field_1352 + this.followDeltaX;
                this.y = pos.field_1351 + this.followDeltaY;
                this.z = pos.field_1350 + this.followDeltaZ;
            }
        } else {
            float leftImpulse;
            float forwardImpulse;
            class_744 input = this.playerInput;
            float f = !this.cameraLock ? (float)((input.field_54155.comp_3159() ? 1 : 0) + (input.field_54155.comp_3160() ? -1 : 0)) : (forwardImpulse = 0.0f);
            float f2 = !this.cameraLock ? (float)((input.field_54155.comp_3161() ? 1 : 0) + (input.field_54155.comp_3162() ? -1 : 0)) : (leftImpulse = 0.0f);
            float upImpulse = !this.cameraLock ? (float)((input.field_54155.comp_3163() ? 1 : 0) + (input.field_54155.comp_3164() ? -1 : 0)) : 0.0f;
            double slowdown = Math.pow(this.config.slowdownFactor, frameTime);
            this.forwardVelocity = this.combineMovement(this.forwardVelocity, forwardImpulse, frameTime, this.config.acceleration, slowdown);
            this.leftVelocity = this.combineMovement(this.leftVelocity, leftImpulse, frameTime, this.config.acceleration, slowdown);
            this.upVelocity = this.combineMovement(this.upVelocity, upImpulse, frameTime, this.config.acceleration, slowdown);
            double dx = (double)this.forwards.x() * this.forwardVelocity + (double)this.left.x() * this.leftVelocity;
            double dy = (double)this.forwards.y() * this.forwardVelocity + this.upVelocity + (double)this.left.y() * this.leftVelocity;
            double dz = (double)this.forwards.z() * this.forwardVelocity + (double)this.left.z() * this.leftVelocity;
            double speed = new class_243(dx *= (double)frameTime, dy *= (double)frameTime, dz *= (double)frameTime).method_1033() / (double)frameTime;
            if (speed > this.config.maxSpeed) {
                double factor = this.config.maxSpeed / speed;
                this.forwardVelocity *= factor;
                this.leftVelocity *= factor;
                this.upVelocity *= factor;
                dx *= factor;
                dy *= factor;
                dz *= factor;
            }
            if (!this.config.rememberInputState || this.dontMoveFreeCamBefore < currTime) {
                this.x += dx;
                this.y += dy;
                this.z += dz;
            }
        }
        this.applyEyeLock(delta.method_60637(true));
    }

    public void onClientTickStart() {
        if (this.active) {
            this.disableKey(this.mc.field_1690.field_1824);
            this.playerInput.method_3129();
        }
    }

    public void onWorldUnload() {
        this.disable();
    }

    public void onRenderWorldLast(Matrix4f pose, Matrix4f projectionMatrix, class_4184 camera) {
        if (!this.active || this.moveAlongPath) {
            return;
        }
        List<FreeCamPath.Entry> path = this.getPath().get();
        if (path.size() < 2) {
            return;
        }
    }

    private void startPath() {
        if (!this.active) {
            return;
        }
        this.moveAlongPath = true;
        this.pathStartTime = System.nanoTime();
    }

    public boolean shouldOverrideCameraEntityPosition(class_1297 entity) {
        if (this.active && !this.cameraLock && !this.eyeLock && !this.followCamera && this.config.target) {
            return entity == this.mc.method_1560() && this.gameRendererPicking || this.freecamHitResultPicking;
        }
        return false;
    }

    public void onRenderDebugScreenLeft(List<String> list) {
        if (this.active) {
            list.add("");
            String coordinates = String.format(Locale.ROOT, "Free Cam XYZ: %.3f / %.5f / %.3f", this.x, this.y, this.z);
            list.add(coordinates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderDebugScreenRight(List<String> list) {
        if (!this.active) {
            return;
        }
        if (this.cameraLock || this.eyeLock || this.followCamera) {
            return;
        }
        if (!this.config.target) {
            return;
        }
        this.freecamHitResultPicking = true;
        try {
            class_239 hit = this.mc.field_1724.method_5745(20.0, 0.0f, false);
            if (hit.method_17783() == class_239.class_240.field_1332) {
                class_2338 pos = ((class_3965)hit).method_17777();
                class_2680 state = this.mc.field_1687.method_8320(pos);
                list.add("");
                list.add(String.valueOf(class_124.field_1073) + "Free Cam Targeted Block: " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260());
                list.add(String.valueOf(ModApiWrapper.instance.BLOCKS.getKey(state.method_26204())));
                for (Map.Entry<class_2769<?>, Comparable<?>> entry : state.method_11656().entrySet()) {
                    list.add(this.getPropertyValueString(entry));
                }
                state.method_40144().map(tag -> "#" + String.valueOf(tag.comp_327())).forEach(list::add);
            }
        }
        finally {
            this.freecamHitResultPicking = false;
        }
    }

    public void onBeforeGameRendererPick() {
        this.gameRendererPicking = true;
    }

    public void onAfterGameRendererPick() {
        this.gameRendererPicking = false;
    }

    private class_744 createFreeCamInput(class_744 playerInput) {
        if (this.config.rememberInputState) {
            return new FreeCamInput(new class_10185(playerInput.field_54155.comp_3159(), playerInput.field_54155.comp_3160(), playerInput.field_54155.comp_3161(), playerInput.field_54155.comp_3162(), playerInput.field_54155.comp_3163(), playerInput.field_54155.comp_3164(), playerInput.field_54155.comp_3165()));
        }
        return new class_744();
    }

    private void applyEyeLock(float partialTicks) {
        if (!this.eyeLock) {
            return;
        }
        class_1297 entity = this.mc.method_1560();
        if (entity == null) {
            return;
        }
        class_243 pos = entity.method_5836(partialTicks);
        double dx = this.x - pos.field_1352;
        double dy = this.y - pos.field_1351;
        double dz = this.z - pos.field_1350;
        this.xRot = (float)(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) / Math.PI * 180.0);
        this.yRot = (float)(Math.atan2(dz, dx) / Math.PI * 180.0 + 90.0);
        this.xRot = class_3532.method_15363((float)this.xRot, (float)-90.0f, (float)90.0f);
        this.calculateVectors();
    }

    private void calculateVectors() {
        this.rotation.rotationYXZ(-this.yRot * ((float)Math.PI / 180), (this.config.spectatorMovement ? 0.0f : this.xRot) * ((float)Math.PI / 180), 0.0f);
        this.forwards.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation);
        this.up.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        this.left.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation);
    }

    private double combineMovement(double velocity, double impulse, double frameTime, double acceleration, double slowdown) {
        if (impulse != 0.0) {
            if (impulse > 0.0 && velocity < 0.0) {
                velocity = 0.0;
            }
            if (impulse < 0.0 && velocity > 0.0) {
                velocity = 0.0;
            }
            velocity += acceleration * impulse * frameTime;
        } else {
            velocity *= slowdown;
        }
        return velocity;
    }

    private String getPropertyValueString(Map.Entry<class_2769<?>, Comparable<?>> p_94072_) {
        class_2769<?> property = p_94072_.getKey();
        Comparable<?> comparable = p_94072_.getValue();
        Object s = class_156.method_650(property, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = String.valueOf(class_124.field_1060) + (String)s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = String.valueOf(class_124.field_1061) + (String)s;
        }
        return property.method_11899() + ": " + (String)s;
    }

    private void disableKey(class_304 key) {
        while (key.method_1436()) {
        }
        key.method_23481(false);
    }

    private void renderLines(class_287 bufferBuilder, Matrix4f pose, Matrix4f projection) {
    }

    private static class FreeCamInput
    extends class_744 {
        public FreeCamInput(class_10185 input) {
            this.field_54155 = input;
            this.field_55868 = new class_241(FreeCamInput.calcImpulse(input.comp_3161(), input.comp_3162()), FreeCamInput.calcImpulse(input.comp_3159(), input.comp_3160())).method_35581();
        }

        private static float calcImpulse(boolean b1, boolean b2) {
            if (b1 == b2) {
                return 0.0f;
            }
            return b1 ? 1.0f : -1.0f;
        }
    }

    private static class SharedVertexBuffer {
        private SharedVertexBuffer() {
        }
    }
}

