/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.mixin;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionPointException;

public class ModifyMethodReturnValueInjector
extends Injector {
    public ModifyMethodReturnValueInjector(InjectionInfo info) {
        super(info, "@ModifyMethodReturnValue");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        InsnList instructions;
        this.checkTargetModifiers(target, false);
        AbstractInsnNode instructionNode = node.getCurrentTarget();
        if (instructionNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)instructionNode;
            Type returnType = Type.getReturnType((String)methodInsnNode.desc);
            if (returnType == Type.VOID_TYPE) {
                throw new InvalidInjectionException((ISelectorContext)this.info, "@ModifyMethodReturnValue should not point to void methods.");
            }
            instructions = new InsnList();
            if (!this.isStatic) {
                ++target.method.maxStack;
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                if (returnType.getSize() == 2) {
                    ++target.method.maxStack;
                    instructions.add((AbstractInsnNode)new InsnNode(91));
                    instructions.add((AbstractInsnNode)new InsnNode(87));
                } else {
                    instructions.add((AbstractInsnNode)new InsnNode(95));
                }
            }
        } else {
            throw new InvalidInjectionPointException(this.info, "@ModifyMethodReturnValue should point to method instruction.", new Object[0]);
        }
        this.invokeHandler(instructions);
        target.insns.insert(instructionNode, instructions);
    }
}

