/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.mixin;

import com.zergatul.mixin.helpers.LocalVarHelper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionPointException;

public class WrapMethodInsideIfConditionInjector
extends Injector {
    public WrapMethodInsideIfConditionInjector(InjectionInfo info) {
        super(info, "@WrapMethodInsideIfCondition");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        LabelNode label;
        InsnList instructions;
        this.checkTargetModifiers(target, false);
        AbstractInsnNode instructionNode = node.getCurrentTarget();
        if (instructionNode instanceof MethodInsnNode) {
            int i;
            MethodInsnNode methodInsnNode = (MethodInsnNode)instructionNode;
            Type returnType = Type.getReturnType((String)methodInsnNode.desc);
            if (returnType != Type.VOID_TYPE) {
                throw new InvalidInjectionException((ISelectorContext)this.info, "@WrapMethodInsideIfCondition should point to void methods.");
            }
            instructions = new InsnList();
            if (!this.isStatic) {
                throw new InvalidInjectionException((ISelectorContext)this.info, "@WrapMethodInsideIfCondition - only static supported.");
            }
            Type[] arguments = Type.getArgumentTypes((String)methodInsnNode.desc);
            if (methodInsnNode.getOpcode() != 184) {
                Type[] args2 = new Type[arguments.length + 1];
                args2[0] = Type.getType(Object.class);
                System.arraycopy(arguments, 0, args2, 1, arguments.length);
                arguments = args2;
            }
            int[] argIndexes = new int[arguments.length];
            int startIndex = target.getCurrentMaxLocals();
            target.extendLocals().add(arguments).apply();
            for (i = 0; i < arguments.length; ++i) {
                argIndexes[i] = startIndex;
                startIndex += arguments[i].getSize();
            }
            for (i = arguments.length - 1; i >= 0; --i) {
                instructions.add((AbstractInsnNode)new VarInsnNode(LocalVarHelper.getStoreInst(arguments[i]), argIndexes[i]));
            }
            for (i = 0; i < arguments.length; ++i) {
                instructions.add((AbstractInsnNode)new VarInsnNode(LocalVarHelper.getLoadInst(arguments[i]), argIndexes[i]));
            }
            this.invokeHandler(instructions);
            label = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                instructions.add((AbstractInsnNode)new VarInsnNode(LocalVarHelper.getLoadInst(arguments[i2]), argIndexes[i2]));
            }
        } else {
            throw new InvalidInjectionPointException(this.info, "@WrapMethodInsideIfCondition should point to method instruction.", new Object[0]);
        }
        target.insns.insertBefore(instructionNode, instructions);
        target.insns.insert(instructionNode, (AbstractInsnNode)label);
    }
}

