/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix.gui;

import b100.fullscreenfix.FullscreenFix;
import b100.fullscreenfix.MonitorInfo;
import b100.fullscreenfix.VideoMode;
import b100.fullscreenfix.mixin.access.IScreen;
import b100.fullscreenfix.util.GLFWUtil;
import b100.fullscreenfix.util.Util;
import b100.gui.FocusDirection;
import b100.gui.Focusable;
import b100.gui.GuiButton;
import b100.gui.GuiElement;
import b100.gui.GuiListButton;
import b100.gui.GuiScreen;
import b100.gui.GuiScrollableList;
import b100.gui.GuiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

@Environment(value=EnvType.CLIENT)
public class ScreenResolutionsMenu
extends GuiScreen {
    protected class_2561 title;
    protected GuiButton cancelButton;
    protected GuiButton applyButton;
    protected int headerSize = 32;
    protected int footerSize = 32;
    protected GuiScrollableList monitorList;
    protected GuiScrollableList resolutionList;
    protected GuiScrollableList refreshRateList;
    protected RefreshRate previousMode;
    protected RefreshRate selectedMode;
    protected final Map<Long, Monitor> monitorMap = new HashMap<Long, Monitor>();
    protected final Map<Monitor, RefreshRate> monitorSettings = new HashMap<Monitor, RefreshRate>();
    protected final Map<Monitor, Resolution> focusCacheResolution = new HashMap<Monitor, Resolution>();
    protected final Map<Resolution, RefreshRate> focusCacheRefreshRate = new HashMap<Resolution, RefreshRate>();
    protected Monitor primaryMonitor;
    protected boolean contentChanged = false;
    protected boolean initialized = false;

    public ScreenResolutionsMenu(IScreen parentScreen) {
        super(parentScreen);
        this.title = FullscreenFix.translate("screen.fullscreenResolution.title");
    }

    @Override
    protected void onInit() {
        this.applyButton = new GuiButton(this, FullscreenFix.translate("button.apply"));
        this.cancelButton = new GuiButton(this, null);
        this.applyButton.addActionListener(e -> this.apply());
        this.cancelButton.addActionListener(e -> this.back());
        GuiScrollableList.ListLayout layout = new GuiScrollableList.ListLayout();
        layout.innerPadding = 0;
        layout.outerPadding = 2;
        this.monitorList = this.add(new GuiScrollableList(this, layout));
        this.resolutionList = this.add(new GuiScrollableList(this, layout));
        this.refreshRateList = this.add(new GuiScrollableList(this, layout));
        ArrayList<Monitor> monitors = new ArrayList<Monitor>();
        int monitorNumber = 0;
        for (long monitorHandle : GLFWUtil.getMonitors()) {
            MonitorInfo monitorInfo = new MonitorInfo(monitorHandle);
            Monitor monitor = this.monitorMap.get(monitorHandle);
            if (monitor == null) {
                monitor = new Monitor(++monitorNumber, monitorInfo);
                this.monitorMap.put(monitorHandle, monitor);
                monitors.add(monitor);
            }
            for (GLFWVidMode vidMode : GLFWUtil.getVideoModes(monitorHandle)) {
                monitor.getOrAdd(vidMode.width(), vidMode.height()).getOrAdd(vidMode);
            }
        }
        this.monitorList.add(new MonitorElement(this, null));
        for (int i = 0; i < monitors.size(); ++i) {
            Monitor monitor = (Monitor)monitors.get(i);
            Util.reverseList(monitor.resolutions);
            this.monitorList.add(new MonitorElement(this, monitor));
            for (Resolution resolution : monitor.resolutions) {
                Util.reverseList(resolution.refreshRates);
            }
        }
        for (Monitor monitor : monitors) {
            Resolution resolution = monitor.get(monitor.info.width, monitor.info.height);
            RefreshRate refreshRate = resolution.get(monitor.info.refreshRate);
            this.monitorSettings.put(monitor, refreshRate);
        }
        RefreshRate fullscreenMode = this.getRefreshRate(FullscreenFix.getFullscreenVideoMode());
        this.primaryMonitor = this.monitorMap.get(GLFW.glfwGetPrimaryMonitor());
        this.previousMode = fullscreenMode;
        this.setFocused(fullscreenMode);
        this.initialized = true;
        this.add(this.applyButton);
        this.add(this.cancelButton);
    }

    @Override
    public void draw() {
        this.utils.drawCenteredString(this.title, this.width / 2, this.headerSize / 2 - 4, 0xFFFFFF, true);
        if (this.contentChanged) {
            this.onResize();
        }
        super.draw();
    }

    public void apply() {
        if (this.selectedMode != null) {
            FullscreenFix.setFullscreenVideoMode(new VideoMode(this.selectedMode.monitor.info.handle, this.selectedMode.vidMode));
        } else {
            FullscreenFix.setFullscreenVideoMode(null);
        }
        FullscreenFix.setFullscreen(true);
        FullscreenFix.saveConfig();
        this.previousMode = this.selectedMode;
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.selectedMode != this.previousMode) {
            this.applyButton.setClickable(true);
            this.cancelButton.text = FullscreenFix.translate("button.cancel");
        } else {
            this.applyButton.setClickable(false);
            this.cancelButton.text = FullscreenFix.translate("button.done");
        }
    }

    @Override
    public boolean keyEvent(int key, int scancode, int modifiers, boolean pressed) {
        if (pressed && key == 257) {
            this.apply();
            this.back();
        }
        return super.keyEvent(key, scancode, modifiers, pressed);
    }

    @Override
    public Focusable getNextScreenFocusableElement(Focusable focusedElement, FocusDirection direction) {
        GuiElement element = (GuiElement)((Object)focusedElement);
        if (this.monitorList.contains(element)) {
            if (direction == FocusDirection.LEFT) {
                return null;
            }
            if (direction == FocusDirection.RIGHT) {
                return this.resolutionList.getLastFocusedElement();
            }
        }
        if (this.resolutionList.contains(element)) {
            if (direction == FocusDirection.LEFT) {
                return this.monitorList.getLastFocusedElement();
            }
            if (direction == FocusDirection.RIGHT) {
                return this.refreshRateList.getLastFocusedElement();
            }
        }
        if (this.refreshRateList.contains(element)) {
            if (direction == FocusDirection.LEFT) {
                return this.resolutionList.getLastFocusedElement();
            }
            if (direction == FocusDirection.RIGHT) {
                return null;
            }
        }
        return super.getNextScreenFocusableElement(focusedElement, direction);
    }

    public RefreshRate getRefreshRate(VideoMode videoMode) {
        if (videoMode == null) {
            return null;
        }
        FullscreenFix.debugPrint("Get RefreshRate: " + videoMode.toConfigString());
        Monitor monitor = this.monitorMap.get(videoMode.monitor);
        FullscreenFix.debugPrint("  Monitor: " + String.valueOf(monitor));
        if (monitor == null) {
            return null;
        }
        Resolution resolution = monitor.get(videoMode.vidMode.width(), videoMode.vidMode.height());
        FullscreenFix.debugPrint("  Resolution: " + String.valueOf(resolution));
        if (resolution == null) {
            return null;
        }
        RefreshRate refreshRate = resolution.get(videoMode.vidMode);
        FullscreenFix.debugPrint("  Refresh Rate: " + String.valueOf(refreshRate));
        return refreshRate;
    }

    public void setFocused(RefreshRate refreshRate) {
        FullscreenFix.debugPrint("Focus: " + String.valueOf(refreshRate));
        if (refreshRate == null) {
            this.getMonitorElement(null).setFocused(true);
            return;
        }
        if (!this.isRefreshRateSet(refreshRate)) {
            if (!this.isResolutionSet(refreshRate.resolution)) {
                if (!this.isMonitorSet(refreshRate.monitor)) {
                    this.getMonitorElement(refreshRate.monitor).setFocused(true);
                }
                this.getResolutionElement(refreshRate.resolution).setFocused(true);
            }
            this.getRefreshRateElement(refreshRate).setFocused(true);
        }
    }

    public boolean setMonitor(Monitor monitor) {
        if (this.isMonitorSet(monitor)) {
            return false;
        }
        FullscreenFix.debugPrint("Set Monitor: " + String.valueOf(monitor));
        this.resolutionList.removeAll();
        if (monitor != null) {
            ResolutionElement resolutionElement;
            for (Resolution resolution : monitor.resolutions) {
                this.resolutionList.add(new ResolutionElement(this, resolution));
            }
            Resolution resolution = this.focusCacheResolution.get(monitor);
            if (resolution == null) {
                resolution = this.monitorSettings.get((Object)monitor).resolution;
            }
            if ((resolutionElement = this.getResolutionElement(resolution)) != null) {
                resolutionElement.setFocused(true);
            } else {
                FullscreenFix.debugPrint("No resolution element to focus!");
            }
        } else {
            this.setResolution(null);
        }
        this.contentChanged = true;
        return true;
    }

    public boolean setResolution(Resolution resolution) {
        if (this.isResolutionSet(resolution)) {
            return false;
        }
        FullscreenFix.debugPrint("Set Resolution: " + String.valueOf(resolution));
        this.refreshRateList.removeAll();
        if (resolution != null) {
            RefreshRateElement refreshRateElement;
            RefreshRate defaultRefreshRate;
            for (RefreshRate refreshRate : resolution.refreshRates) {
                this.refreshRateList.add(new RefreshRateElement(this, refreshRate));
            }
            this.focusCacheResolution.put(resolution.monitor, resolution);
            this.focusCacheRefreshRate.clear();
            RefreshRate refreshRate = this.focusCacheRefreshRate.get(resolution);
            if (refreshRate == null && (defaultRefreshRate = this.monitorSettings.get(resolution.monitor)) != null && defaultRefreshRate.resolution == resolution) {
                refreshRate = defaultRefreshRate;
            }
            if (refreshRate == null) {
                refreshRate = resolution.refreshRates.get(0);
            }
            if ((refreshRateElement = this.getRefreshRateElement(refreshRate)) != null) {
                refreshRateElement.setFocused(true);
            } else {
                FullscreenFix.debugPrint("No element to focus for " + String.valueOf(refreshRate) + "!");
            }
        } else {
            this.setRefreshRate(null);
        }
        this.contentChanged = true;
        return true;
    }

    public boolean setRefreshRate(RefreshRate refreshRate) {
        if (this.isRefreshRateSet(refreshRate)) {
            return false;
        }
        FullscreenFix.debugPrint("Set Refresh Rate: " + String.valueOf(refreshRate));
        if (refreshRate != null) {
            this.focusCacheRefreshRate.put(refreshRate.resolution, refreshRate);
        }
        this.selectedMode = refreshRate;
        this.updateButtons();
        return true;
    }

    public boolean isMonitorSet(Monitor monitor) {
        if (!this.initialized) {
            return false;
        }
        if (this.selectedMode == null) {
            return monitor == null;
        }
        return this.selectedMode.monitor == monitor;
    }

    public boolean isResolutionSet(Resolution resolution) {
        if (!this.initialized) {
            return false;
        }
        if (this.selectedMode == null) {
            return resolution == null;
        }
        return this.selectedMode.resolution == resolution;
    }

    public boolean isRefreshRateSet(RefreshRate refreshRate) {
        if (!this.initialized) {
            return false;
        }
        return this.selectedMode == refreshRate;
    }

    public MonitorElement getMonitorElement(Monitor monitor) {
        for (GuiElement element : this.monitorList.elements) {
            if (!(element instanceof MonitorElement)) continue;
            MonitorElement monitorElement = (MonitorElement)element;
            if (monitorElement.monitor != monitor) continue;
            return monitorElement;
        }
        return null;
    }

    public ResolutionElement getResolutionElement(Resolution resolution) {
        for (GuiElement element : this.resolutionList.elements) {
            if (!(element instanceof ResolutionElement)) continue;
            ResolutionElement resolutionElement = (ResolutionElement)element;
            if (resolutionElement.resolution != resolution) continue;
            return resolutionElement;
        }
        return null;
    }

    public RefreshRateElement getRefreshRateElement(RefreshRate refreshRate) {
        for (GuiElement element : this.refreshRateList.elements) {
            if (!(element instanceof RefreshRateElement)) continue;
            RefreshRateElement resolutionElement = (RefreshRateElement)element;
            if (resolutionElement.refreshRate != refreshRate) continue;
            return resolutionElement;
        }
        return null;
    }

    @Override
    public void onResize() {
        int p = 5;
        int resolutionListWidth = Math.min(220, this.width / 2);
        int smallListsWidth = Math.min(100, this.width / 4 - 2 * p);
        int x0 = this.width / 2 - resolutionListWidth / 2;
        int y0 = this.headerSize;
        int y1 = y0 + 16;
        int h1 = this.height - this.headerSize - this.footerSize;
        int h2 = h1 / 2;
        this.resolutionList.setPosition(x0, y0).setSize(resolutionListWidth, h1);
        this.monitorList.setPosition(x0 - p - smallListsWidth, y1).setSize(smallListsWidth, h2);
        this.refreshRateList.setPosition(x0 + resolutionListWidth + p, y1).setSize(smallListsWidth, h2);
        for (GuiElement element : this.resolutionList.elements) {
            element.setSize(resolutionListWidth, 20);
        }
        for (GuiElement element : this.monitorList.elements) {
            element.setSize(smallListsWidth, 20);
        }
        for (GuiElement element : this.refreshRateList.elements) {
            element.setSize(smallListsWidth, 20);
        }
        GuiUtils.setDoubleFooterButtonPositions(this, this.height - this.footerSize + 4, this.applyButton, this.cancelButton);
        super.onResize();
    }

    @Override
    public Focusable getNextFocusable(GuiElement element, FocusDirection direction) {
        return super.getNextFocusable(element, direction);
    }

    @Environment(value=EnvType.CLIENT)
    class Monitor {
        public final int id;
        public final MonitorInfo info;
        public final String name;
        public final List<Resolution> resolutions = new ArrayList<Resolution>();

        public Monitor(int id, MonitorInfo monitorInfo) {
            this.id = id;
            this.info = monitorInfo;
            this.name = GLFW.glfwGetMonitorName((long)monitorInfo.handle);
        }

        public Resolution get(int w, int h) {
            for (Resolution resolution : this.resolutions) {
                if (resolution.width != w || resolution.height != h) continue;
                return resolution;
            }
            return null;
        }

        public Resolution getOrAdd(int w, int h) {
            Resolution resolution = this.get(w, h);
            if (resolution == null) {
                resolution = new Resolution(this, w, h);
                this.resolutions.add(resolution);
            }
            return resolution;
        }

        public String toString() {
            return "Monitor[" + this.id + "]";
        }
    }

    @Environment(value=EnvType.CLIENT)
    class Resolution {
        public final Monitor monitor;
        public final int width;
        public final int height;
        public final List<RefreshRate> refreshRates = new ArrayList<RefreshRate>();

        public Resolution(Monitor monitor, int width, int height) {
            this.monitor = monitor;
            this.width = width;
            this.height = height;
        }

        public RefreshRate getOrAdd(GLFWVidMode vidMode) {
            RefreshRate refreshRate = this.get(vidMode);
            if (refreshRate == null) {
                refreshRate = new RefreshRate(ScreenResolutionsMenu.this, this, vidMode);
                this.refreshRates.add(refreshRate);
            }
            return refreshRate;
        }

        public RefreshRate get(GLFWVidMode vidMode) {
            for (RefreshRate refreshRate : this.refreshRates) {
                if (!refreshRate.vidMode.equals((Object)vidMode)) continue;
                return refreshRate;
            }
            return null;
        }

        public RefreshRate get(int rate) {
            for (RefreshRate refreshRate : this.refreshRates) {
                if (refreshRate.vidMode.refreshRate() != rate) continue;
                return refreshRate;
            }
            return null;
        }

        public String toString() {
            return "Resolution[" + String.valueOf(this.monitor) + "," + this.width + "x" + this.height + "]";
        }
    }

    @Environment(value=EnvType.CLIENT)
    class RefreshRate {
        public final Monitor monitor;
        public final Resolution resolution;
        public final GLFWVidMode vidMode;

        public RefreshRate(ScreenResolutionsMenu this$0, Resolution resolution, GLFWVidMode vidMode) {
            this.monitor = resolution.monitor;
            this.resolution = resolution;
            this.vidMode = vidMode;
        }

        public int get() {
            return this.vidMode.refreshRate();
        }

        public String toString() {
            return "RefreshRate[" + String.valueOf(this.resolution) + "," + this.vidMode.refreshRate() + "hz]";
        }
    }

    @Environment(value=EnvType.CLIENT)
    class MonitorElement
    extends GuiListButton {
        public Monitor monitor;

        public MonitorElement(GuiScreen screen, Monitor monitor) {
            super(screen);
            this.monitor = monitor;
            this.text = monitor != null ? class_2561.method_30163((String)("Monitor " + monitor.id)) : FullscreenFix.translate("option.fullscreenResolution.default");
        }

        @Override
        public void onFocusChanged() {
            if (this.isFocused()) {
                ScreenResolutionsMenu.this.setMonitor(this.monitor);
            }
            super.onFocusChanged();
        }
    }

    @Environment(value=EnvType.CLIENT)
    class ResolutionElement
    extends GuiListButton {
        public Resolution resolution;

        public ResolutionElement(GuiScreen screen, Resolution resolution) {
            super(screen);
            this.resolution = resolution;
            this.text = class_2561.method_30163((String)(resolution.width + " x " + resolution.height));
        }

        @Override
        public void onFocusChanged() {
            if (this.isFocused()) {
                ScreenResolutionsMenu.this.setResolution(this.resolution);
            }
            super.onFocusChanged();
        }
    }

    @Environment(value=EnvType.CLIENT)
    class RefreshRateElement
    extends GuiListButton {
        public RefreshRate refreshRate;

        public RefreshRateElement(GuiScreen screen, RefreshRate refreshRate) {
            super(screen);
            this.refreshRate = refreshRate;
            this.text = class_2561.method_30163((String)(refreshRate.get() + " hz"));
        }

        @Override
        public void onFocusChanged() {
            if (this.isFocused()) {
                ScreenResolutionsMenu.this.setRefreshRate(this.refreshRate);
            }
            super.onFocusChanged();
        }
    }
}

