/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix.util;

import b100.fullscreenfix.MonitorInfo;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_319;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

@Environment(value=EnvType.CLIENT)
public class GLFWUtil {
    public static void enableFullscreen(class_1041 window, MonitorInfo monitor) {
        GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)monitor.handle, (int)monitor.posX, (int)monitor.posY, (int)monitor.width, (int)monitor.height, (int)monitor.refreshRate);
    }

    public static void disableFullscreen(class_1041 window, int x, int y, int w, int h) {
        GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)0L, (int)x, (int)y, (int)w, (int)h, (int)0);
    }

    public static boolean isFullscreen(class_1041 window) {
        return GLFW.glfwGetWindowMonitor((long)window.method_4490()) != 0L;
    }

    public static List<Long> getMonitors() {
        ArrayList<Long> list = new ArrayList<Long>();
        PointerBuffer buffer = GLFW.glfwGetMonitors();
        while (buffer.position() < buffer.limit()) {
            list.add(buffer.get());
        }
        return list;
    }

    public static List<GLFWVidMode> getVideoModes(long monitor) {
        ArrayList<GLFWVidMode> list = new ArrayList<GLFWVidMode>();
        GLFWVidMode.Buffer buffer = GLFW.glfwGetVideoModes((long)monitor);
        while (buffer.hasRemaining()) {
            list.add((GLFWVidMode)buffer.get());
        }
        return list;
    }

    public static GLFWVidMode findMatchingVidMode(class_319 videoMode) {
        for (GLFWVidMode vidMode : GLFWUtil.getVideoModes(GLFW.glfwGetPrimaryMonitor())) {
            if (vidMode.width() != videoMode.method_1668() || vidMode.height() != videoMode.method_1669() || vidMode.refreshRate() != videoMode.method_1671()) continue;
            return vidMode;
        }
        return null;
    }

    public static long findMonitor(int x, int y, int width, int height) {
        for (long monitor : GLFWUtil.getMonitors()) {
            MonitorInfo monitorInfo = new MonitorInfo(monitor);
            if (monitorInfo.posX != x || monitorInfo.posY != y || monitorInfo.width != width || monitorInfo.height != height) continue;
            return monitor;
        }
        return 0L;
    }

    public static GLFWVidMode getMonitorVidMode(long monitor, int width, int height, int refreshRate) {
        for (GLFWVidMode vidMode : GLFWUtil.getVideoModes(monitor)) {
            if (vidMode.width() != width || vidMode.height() != height || vidMode.refreshRate() != refreshRate) continue;
            return vidMode;
        }
        return null;
    }
}

