/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.gui.FocusDirection;
import b100.gui.FocusListener;
import b100.gui.GuiContainer;
import b100.gui.GuiElement;
import b100.gui.ListenerList;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public interface Focusable {
    public static final Function<GuiElement, Boolean> FOCUSABLE_CONDITION = element -> Focusable.isFocusable(element);

    public void setFocused(boolean var1);

    public boolean isFocused();

    public boolean isFocusable();

    public ListenerList<FocusListener> getFocusListeners();

    public GuiContainer getContainer();

    public static boolean isFocusable(GuiElement element) {
        if (element instanceof Focusable) {
            Focusable focusable = (Focusable)((Object)element);
            return focusable.isFocusable();
        }
        return false;
    }

    public static Focusable findNextFocusableElement(GuiElement element, FocusDirection direction) {
        try {
            return Focusable.findNextFocusableElementDo(element, direction);
        }
        catch (CancelAction e) {
            return null;
        }
    }

    private static Focusable findNextFocusableElementDo(GuiElement element, FocusDirection direction) throws CancelAction {
        GuiContainer container = element.getContainer();
        if (container == null) {
            return null;
        }
        Focusable next = container.getNextFocusable(element, direction);
        if (next != null) {
            return next;
        }
        if (direction.isArrowKey() && container.isList) {
            throw new CancelAction();
        }
        return Focusable.findNextFocusableElementDo(container, direction);
    }

    @Environment(value=EnvType.CLIENT)
    public static class CancelAction
    extends Exception {
    }
}

