/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.fullscreenfix.mixin.access.IScreen;
import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.GuiScrollBar;
import b100.gui.GuiScrollableList;
import b100.gui.GuiUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public abstract class GuiScrollListScreen
extends GuiScreen {
    public GuiScrollableList scrollList;
    public GuiScrollBar scrollBar;
    public GuiScrollableList.Layout listLayout;
    public int headerSize = 32;
    public int footerSize = 32;
    public class_2561 title;

    public GuiScrollListScreen(IScreen parentScreen) {
        super(parentScreen);
    }

    public abstract void initScrollElements();

    @Override
    protected void onInit() {
        this.listLayout = this.getListLayout();
        this.scrollList = this.add(new GuiScrollableList(this, this.listLayout));
        this.scrollBar = this.add(new GuiScrollBar(this, this.scrollList));
        this.initScrollElements();
    }

    @Override
    public void draw() {
        super.draw();
        if (this.title != null) {
            this.utils.drawCenteredString(this.title, this.width / 2, this.headerSize / 2 - 4, -1, true);
        }
    }

    @Override
    public void onResize() {
        int scrollBarWidth = 6;
        this.scrollList.setPosition(0, this.headerSize).setSize(this.width, this.height - (this.headerSize + this.footerSize));
        int contentWidth = this.listLayout.getContentWidth(this.scrollList);
        this.scrollBar.setPosition(this.scrollList.posX + this.scrollList.width / 2 + contentWidth / 2 + 16, this.scrollList.posY + 2).setSize(6, this.scrollList.height - 4);
        super.onResize();
    }

    public void setDoubleFooterButtonPositions(GuiElement left, GuiElement right) {
        GuiUtils.setDoubleFooterButtonPositions(this, this.height - this.footerSize + 4, left, right);
    }

    public GuiScrollableList.Layout getListLayout() {
        return new GuiScrollableList.ListLayout();
    }
}

