#define PHOXEL

// Textures //
uniform sampler2D depthtex0;
uniform sampler2D colortex0; // Albedo
uniform sampler2D colortex1; // Normals
uniform sampler2D colortex2; // Specular
/*
    const int colortex7Format = RGB16F;
*/

// Uniforms //
uniform vec3 cameraPosition;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;

uniform int heldBlockLightValue;
uniform int heldBlockLightValue2;

// Includes //
#include ../Utility/Settings.glsl
#include ../Utility/VoxelMaps.glsl
#include ../Utility/RenderStructures.glsl
#include ../Utility/Raycast.glsl
#include ../Utility/Materials.glsl
#include ../Utility/Atmosphere.glsl
#include ../Utility/Random.glsl

// Constants //
vec3 EyeCameraPosition = cameraPosition + gbufferModelViewInverse[3].xyz;

vec3 ProjectNDivide(mat4 Matrix, vec3 Pos){
    vec4 HgnsPos = Matrix*vec4(Pos,1);
    return HgnsPos.xyz/HgnsPos.w;
}

// Sun, Moon, Handheld lights
vec3 TraceToImaginaryLights(RayStr Ray, HitDataStr HitData){
    RayStr ShadowRay = Ray;
    vec3 OutLight = vec3(0.0);
    #ifdef TracedHandLights
        const float LighBias = 0.5;
    #else
        const float LightBias = 1.0;
    #endif

    float Factor = 0.0;
    HitDataStr ShadowHit;

    #ifdef TracedHandLights
    if (Random_GetVec().x > 0.5){
    #endif
            if (biome_category != CAT_NETHER && biome_category != CAT_THE_END){
            if (SunPos.y > 0.0){
                PointRayTowards(ShadowRay, SunPos + Random_GetDir()*15.0*SunPenumbra);
                Factor = clamp(dot(HitData.Normal, ShadowRay.Direction), 0.0, 1.0);
                //if (Factor == 0.0) break;
                ShadowHit = GetIntersection(ShadowRay, MaxDist);
                if (ShadowHit.t == MaxDist) OutLight += Factor*SunColor*SunBrightness*min(normalize(SunPos).y*4.0, 1.0);
            } else{
                PointRayTowards(ShadowRay, MoonPos + Random_GetDir()*40.0*MoonPenumbra);
                Factor = clamp(dot(HitData.Normal, ShadowRay.Direction), 0.0, 1.0);
                //if (Factor == 0.0) break;
                ShadowHit = GetIntersection(ShadowRay, MaxDist);
                if (ShadowHit.t == MaxDist) OutLight += Factor*MoonColor*MoonBrightness*min(normalize(MoonPos).y*4.0, 1.0);
            }
        }
    #ifdef TracedHandLights
    } else {
        // Make sure to ignore if position is on hand later
        vec3 PlayerPosition = vec3(Voxelization_Distance/2) + fract(EyeCameraPosition) + (0.15*normalize(mat3(gbufferModelViewInverse)*ProjectNDivide(gbufferProjectionInverse,vec3(-0.8*sign(heldBlockLightValue2-0.01), -0.8, 0.5))));
        if (heldBlockLightValue > 0){
            PointRayTowards(ShadowRay, PlayerPosition);
            Factor = clamp(dot(HitData.Normal, ShadowRay.Direction), 0.0, 1.0);
            if (Factor != 0.0){
                float Distance = length(ShadowRay.Origin - PlayerPosition);
                ShadowHit = GetIntersection(ShadowRay, Distance);
                if (ShadowHit.t == Distance){
                    // bad temporary fix for nonexistant BRDF
                    OutLight += Factor*heldBlockLightValue/max(Distance*Distance, 8.0);
                }
            }
        }
    }
    #endif

    return OutLight/LightBias;
}

vec3 GetLight(RayStr Ray, HitDataStr HitData){
    return TraceToImaginaryLights(Ray, HitData);
}

float Fresnel(float d, float f0){
    return f0*pow(1.0-d, 5.0);
}

void Bounce(inout RayStr Ray, HitDataStr HitData, float FresnelFactor){
    vec3 Reflection = reflect(Ray.Direction, HitData.Normal);
    // If perfect reflection, set and exit
    if (FresnelFactor == 1.0) {Ray.Direction = Reflection; return;}

    float IOR = (1.0 - sqrt(HitData.Material.F0)) / (1.0 + sqrt(HitData.Material.F0));
    //vec3 Refraction = refract(Ray.Direction, HitData.Normal, IOR/Ray.IOR)

    Ray.Direction = normalize(HitData.Normal + Random_GetDir());
    if (Random_GetVec().x * 2.0 > HitData.Material.F0) return;
    Ray.Direction = normalize(mix(Reflection, Ray.Direction, HitData.Material.Roughness));
}

vec3 PathTrace(){
    vec3 ndc = vec3(TextureUV, texture(depthtex0, TextureUV))*2.0 - 1.0;

    #if (!defined DebugView) && (!defined Render)
        if (ndc.z == 1.0) return vec3(1.0);
    #endif

    RayStr ViewRay = RayStr(
        fract(EyeCameraPosition) + vec3(Voxelization_Distance/2),
        normalize(mat3(gbufferModelViewInverse)*ProjectNDivide(gbufferProjectionInverse,ndc)),
        vec3(1), vec3(0)
    );

    // First hit depends on mode //
    HitDataStr HitData = HitDataStr(0.0, vec3(0), BaseMaterial);
    #if defined Render || defined DebugView
        ViewRay.Direction.xy += (Random_GetVec().xy * 2.0 - 1.0)/vec2(viewWidth, viewHeight);
        HitData = GetIntersection(ViewRay, MaxDist);
        // To keep same color as vanilla, ignore counter gamma
        #ifdef DebugView
            if (HitData.t >= MaxDist) return ViewRay.Light + ViewRay.Tint*pow(Atmosphere_SampleSky(ViewRay), vec3(Camera_Gamma));
        #else
            if (HitData.t >= MaxDist) return ViewRay.Light + ViewRay.Tint*pow(Atmosphere_SampleVanillaSky(ViewRay), vec3(Camera_Gamma));
        #endif
        ViewRay.Origin += ViewRay.Direction*HitData.t;
        Material_GetFromVoxel(ViewRay, HitData);
    #else
        HitData.t = length(mat3(gbufferModelViewInverse)*ProjectNDivide(gbufferProjectionInverse,ndc)) - 0.05;
        RayStr CorrectionRay = ViewRay;
        CorrectionRay.Origin += CorrectionRay.Direction * HitData.t;
        HitData.t += GetIntersection(CorrectionRay, 0.1).t;
        ViewRay.Origin += ViewRay.Direction * (HitData.t - Epsilon);

        HitData.Normal = texture(colortex1, TextureUV).rgb*2.0 - 1.0;
        HitData.Material = Material_GetFromSpecular(texture(colortex2, TextureUV));
        HitData.Material.Color = texture(colortex0, TextureUV);
    #endif
    float FresnelFactor = float(Random_GetVec().x <= Fresnel(dot(-ViewRay.Direction, HitData.Normal), HitData.Material.F0));
    #if defined Render || defined DebugView
        ViewRay.Tint = mix(HitData.Material.Color.rgb, vec3(1.0), FresnelFactor*float(HitData.Material.F0 <= 1.0));
    #else
        ViewRay.Tint = mix(
            vec3(1.0),
            vec3(1.0) / (pow(HitData.Material.Color.rgb, vec3(Camera_Gamma)) + vec3(HitData.Material.Color.r == 0.0, HitData.Material.Color.g == 0.0, HitData.Material.Color.b == 0.0)),
            FresnelFactor*float(HitData.Material.F0 <= 1.0)
        );
        ViewRay.Tint = clamp(ViewRay.Tint, vec3(0.0), vec3(30.0));
    #endif
    ViewRay.Light = ViewRay.Tint * GetLight(ViewRay, HitData) * (1.0 - FresnelFactor);
    ViewRay.Light += ViewRay.Tint * HitData.Material.Color.rgb * HitData.Material.Emission * BlockLightEmissionStrength;
    
    Bounce(ViewRay, HitData, FresnelFactor);

    for (int BounceN = 0; BounceN < Max_Bounces; BounceN++){
        if (length(ViewRay.Tint) < 0.01) break;
        HitData = GetIntersection(ViewRay, MaxDist);
        // To keep same color as vanilla, ignore counter gamma
        if (HitData.t == MaxDist) return ViewRay.Light + ViewRay.Tint*pow(Atmosphere_SampleSky(ViewRay), vec3(Camera_Gamma));
        ViewRay.Origin += ViewRay.Direction * HitData.t;
        Material_GetFromVoxel(ViewRay, HitData);

        FresnelFactor = float(Random_GetVec().x <= Fresnel(dot(-ViewRay.Direction, HitData.Normal), HitData.Material.F0));
        // Tint Reflection if it's a metal
        ViewRay.Tint *= mix(HitData.Material.Color.rgb, vec3(1.0), FresnelFactor*float(HitData.Material.F0 <= 1.0));
        ViewRay.Light += ViewRay.Tint * GetLight(ViewRay, HitData) * (1.0 - FresnelFactor);
        ViewRay.Light += ViewRay.Tint * HitData.Material.Color.rgb * HitData.Material.Emission * BlockLightEmissionStrength;
        Bounce(ViewRay, HitData, FresnelFactor);
    }
    return ViewRay.Light;
}

void main(){
    Random_Initailize();
    FragColor.rgb = PathTrace();
}