#define TA 

// Textures //
uniform sampler2D depthtex0;
uniform sampler2D colortex0; // Albedo
uniform sampler2D colortex1; // Normals
uniform sampler2D colortex4; // Last Depth and Exposure
uniform sampler2D colortex3; // Last Render
uniform sampler2D colortex7; // Current Render

uniform usampler2D colortex6; // Basic composite information (Just sample count rn)
/*
    const bool colortex4Clear = false;
    const int colortex4Format = RG16;

    const bool colortex3Clear = false;
    const int colortex3Format = RGB16F;

    const bool colortex6Clear = false;
    const int colortex6Format = R16UI;

    const bool colortex0MipmapEnabled = true;
    const bool colortex7MipmapEnabled = true;
*/

// Uniforms //
uniform float near;
uniform float far;
uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

// In //
in vec2 TextureUV;

// Out //
/* RENDERTARGETS: 7,3,4,6 */
layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 StoreColor;
layout (location = 2) out vec2 StoreData; // Depth & Exposure
layout (location = 3) out int SampleCount;

// Includes //
#include ../Utility/Settings.glsl

// Constants //
mat4 gbufferPreviousModelViewInverse = inverse(gbufferPreviousModelView);
ivec2 ScreenSize = ivec2(viewWidth*RenderScale, viewHeight*RenderScale);

float linearizeDepthFast(float depth) {
    return (near * far) / (depth * (near - far) + far);
}

float UnlinearizeDepth(float Depth){
    return ((near * far / Depth) - far) / (near - far);
}

vec3 ProjectAndDivide(mat4 Matrix, vec3 Pos){
    vec4 HgnsPos = Matrix*vec4(Pos,1);
    return HgnsPos.xyz/HgnsPos.w;
}

float GetLumenosity(vec3 RGB){
    vec3 Factors = vec3(0.7,1.0,0.6) * 1.0;
    vec3 Components = RGB*Factors;
    float Total = Components.r + Components.g + Components.b;
    Components *= Components / Total;
    Total = Components.r + Components.g + Components.b;
    return Total;
}

void main(){
    FragColor = texture(colortex7, TextureUV);
    StoreColor = FragColor;

    #if defined Render
        // Delayed static accumulation
        #ifdef DebugView
            int CurrentSample = 0;
        #else
            int CurrentSample = min(int(texture(colortex6, TextureUV).r), RenderTA);
        #endif
        if (frameTimeCounter > Render_Delay){
            CurrentSample += 1;
            StoreColor = (texture(colortex7, TextureUV) / float(CurrentSample)) + (texture(colortex3, TextureUV) * (1.0 - (1.0/float(CurrentSample)) ));
        }
    #elif (TemporalAccumulation != 1)
        // Instant dynamic accumulation
        vec3 ViewPosition = ProjectAndDivide(gbufferProjectionInverse, vec3(TextureUV, texture(depthtex0, TextureUV).r)*2.0-1.0);
        vec4 PreviousPlayerPos = gbufferModelViewInverse * vec4(ViewPosition, 1.0) - vec4((previousCameraPosition - cameraPosition), 0.0);
        vec3 PreviousViewPosition = (gbufferPreviousModelView * PreviousPlayerPos).xyz;

        vec2 Reprojection = ProjectAndDivide(gbufferPreviousProjection, PreviousViewPosition).xy * 0.5 + 0.5;
        vec3 PreviousWorldPosition = (mat3(gbufferPreviousModelViewInverse) * ProjectAndDivide(inverse(gbufferPreviousProjection), vec3(Reprojection, texture(colortex4, Reprojection).r)*2.0-1.0)) + previousCameraPosition + gbufferPreviousModelViewInverse[3].xyz;
        vec3 CurrentWorldPosition = mat3(gbufferModelViewInverse) * ViewPosition + cameraPosition + gbufferModelViewInverse[3].xyz;

        float CurrentDepth = linearizeDepthFast(texture(depthtex0, TextureUV).r);

        int CurrentSample = min(int(texture(colortex6, TextureUV).r) + 1, TemporalAccumulation);
        if (clamp(Reprojection.xy, 0.0, 1.0) != Reprojection.xy ||
            length(PreviousWorldPosition - CurrentWorldPosition) > sqrt(CurrentDepth) / 10.0
            || CurrentDepth < 0.113) CurrentSample = 1;

        StoreColor = (texture(colortex7, TextureUV) / float(CurrentSample)) + (texture(colortex3, Reprojection) * (1.0 - (1.0/float(CurrentSample)) ));
    #else
        int CurrentSample = 1;
    #endif

    SampleCount = CurrentSample;
    FragColor = StoreColor;

    int ExposureLOD = 6;

    float CurrentExposure = GetLumenosity(textureLod(colortex0, TextureUV+(vec2(1<<ExposureLOD)/vec2(ScreenSize)), float(ExposureLOD)).rgb*textureLod(colortex7, TextureUV+(vec2(1<<ExposureLOD)/vec2(ScreenSize)), float(ExposureLOD)).rgb);
    float LastExposure = texture(colortex4, TextureUV).g * ExposureMax;
    if (frameTimeCounter == 0.0) LastExposure = 1.0;
    float ExposureChange = (1.0 / clamp(CurrentExposure, ExposureMin, ExposureMax)) - LastExposure;

    StoreData = vec2(texture(depthtex0, TextureUV).r, clamp(LastExposure + (ExposureChange / (100.0*abs(ExposureChange))), ExposureMin, ExposureMax) / ExposureMax);
}