#define POM

//#define LabPBR
float GetDepth(vec2 UV){
    #ifdef LabPBR
        return texelFetch(normals, ivec2(UV*vec2(atlasSize)), 0).a;
    #else
        return 1.0;
        float Depth = 0.25*dot(texture(gtexture, UV).rgb, vec3(0.77, 1.0, 0.68));
        return (clamp(Depth, 0.0, 1.0)*0.2)+0.8;
    #endif
}

vec2 GetParallax(vec2 UV, vec3 TextureRay, vec2 TextureUVSize){
    #ifndef POM
        return UV;
    #endif
    if (GetDepth(UV) == 1.0) return UV;
    vec3 OffsetUV = vec3(UV, 1.0);

    int Steps = int(max(1024.0 * POMDepth * length(TextureRay.xy) * length(TextureRay.xy), 48.0) * POMQuality);
    vec3 Step = -vec3(TextureRay.xy*TextureUVSize*POMDepth/TextureRay.z, 1.0) / float(Steps);
    for (int i = 0; i < Steps; i++){
        vec3 Next = OffsetUV + Step;
        Next.xy = mod(Next.xy - BottomCoord, TextureUVSize) + BottomCoord;
        if (GetDepth(Next.xy) > Next.z){
            return Next.xy;
        }
        OffsetUV = Next;
    }
    return OffsetUV.xy;
}