#define RANDOM

// Textures //
uniform sampler2D noisetex;

// Uniforms //
uniform int frameCounter;
uniform float viewWidth;
uniform float viewHeight;

// Constants //
const ivec2 NoiseTexSize = ivec2(textureSize(noisetex, 0));
const ivec2 ScreenSize = ivec2(viewWidth*RenderScale, viewHeight*RenderScale);

// Globals //
ivec2 Texel;
int Seed;

#ifndef SETTINGS
    #include Settings.glsl
#endif

// Code //
vec3 Random_GetVec(){
    Seed = (Seed+5677) % (NoiseTexSize.x*NoiseTexSize.y);
    ivec2 Lookup = ivec2(Seed % NoiseTexSize.x, Seed / NoiseTexSize.x);
    return texelFetch(noisetex, Lookup, 0).rgb;
}

vec3 Random_GetDir(){
    return normalize(Random_GetVec()*2.0-1.0); // Fix this with correct sampling
}

void Random_Initailize(){
    Texel = ivec2(TextureUV * ScreenSize);
    Seed = Texel.x + int(frameCounter*177) + int(Texel.y*ScreenSize.x);
    Seed += Seed / (NoiseTexSize.x*NoiseTexSize.y);
    Seed = Seed % (NoiseTexSize.x*NoiseTexSize.y);
}