#define SETTINGS

// Render //
//#define Render
#define Render_Delay 0.5 // [0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0 3.25 3.5 3.75 4.0 4.25 4.5 4.75 5.0]
#define RenderTA 300 // [20 40 60 80 100 120 140 160 180 200 220 240 260 280 300]
#define Render_Intersection_Distance 64 // [8 16 24 32 40 48 56 64 72 80 88 96 104 112 120 128 136 144 152 160 168 176 184 192 200 208 216 224 232 240 248 256]
#define Render_Max_Bounces 8 // [4 5 6 7 8 9 10 11 12 13 14 15 16]

// Path Tracer //
#ifdef Render
    #define Intersection_Distance Render_Intersection_Distance
    #define Max_Bounces Render_Max_Bounces
#else
    #define Intersection_Distance 32 // [4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80 84 88 92 96 100 104 108 112 116 120 124 128 132 136 140 144 148 152 156 160 164 168 172 176 180 184 188 192 196 200 204 208 212 216 220 224 228 232 236 240 244 248 252 256]
    #define Max_Bounces 2 // [0 1 2 3 4 5 6 7 8 9 10 11 12]
#endif

// Voxelization //
//#define Settings_Exclude_Non_Voxels
#define Voxelization_Distance 256 // [64 96 128 160 192 224 256]

// Lighting //

// Atmosphere
// -- Sun Color --
#define SunColorRed 0.95 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SunColorGreen 0.6 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SunColorBlue 0.4 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define SunPenumbra 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define SunBrightness 1.8 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

// -- Moon Color --
#define MoonColorRed 0.05 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define MoonColorGreen 0.1 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define MoonColorBlue 0.15 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1.0]
#define MoonPenumbra 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define MoonBrightness 0.6 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

// Materials //
#define BlockLightEmissionStrength 3.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0]
#define NormalMapStrength 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define POM
#define POMDepth 0.2 // [0.0 0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]
#define POMDistance 16 // [8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32]
#define POMQuality 0.35 // [0.15 0.35 0.65 1.0]

// Post Processing //
#define TemporalAccumulation 4 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16]
#define RenderScale 1.0 // [1.0] -- Make sure to use the sqrt(%)

// -- Similarity Denoiser --
#define Similarity_Denoiser
#define Similarity_Denoiser_SampleArea 2 // [0 1 2 3 4 5]
#define Similarity_Denoiser_Falloff 0.4 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

// Camera //
#define Camera_Gamma 2.2 // [0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6]
#define Camera_Brightness 0.8 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Camera_AutoExposureStrength 0.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define ExposureMin 0.1
#define ExposureMax 1.5

// Debug //
//#define DebugView
//#define TracedHandLights

// Set by shader //
const float ambientOcclusionLevel = 0.0;
const float sunPathRotation = 10.0;

// For Show Only //

// Remove const declarations if AMD GPU because apparently they don't like constant variables
// !!MAKE SURE YOU PUT ANY IRIS PROPERTIES OR OTHERWISE REQUIRED CONSTANTS BEFORE INCLUDING SETTINGS!!
#ifdef MC_GL_VENDOR_AMD
    #define const
#endif