#version 430 compatibility

// Textures //
uniform sampler2D colortex0;
uniform sampler2D colortex4; // Depth and Exposure
uniform sampler2D colortex7; // Render

// In //
in vec2 TextureUV;

// Out //
/* RENDERTARGETS: 0 */
layout (location = 0) out vec4 FragColor;

// Includes //
#include Utility/Settings.glsl

void main(){
    #if defined Render || defined DebugView
        FragColor = texture(colortex7, TextureUV);
    #else
        FragColor = pow(texture(colortex0, TextureUV), vec4(Camera_Gamma))*texture(colortex7, TextureUV);
    #endif
    FragColor = pow(FragColor, vec4(1.0/Camera_Gamma))*Camera_Brightness;
    //FragColor *= mix(1.0, texture(colortex4, vec2(0.5)).g*3.0, Camera_AutoExposureStrength*0.8);
}