#version 430 compatibility

uniform sampler2D lightmap;
uniform sampler2D gtexture;
uniform sampler2D specular;

in vec2 TextureUV;
in vec2 LightMapUV;
in vec4 GlColor;
in vec3 VertexNormal;

/* DRAWBUFFERS: 012*/
layout(location = 0) out vec4 Albedo;
layout(location = 1) out vec4 Normal;
layout(location = 2) out vec4 Specular;

void main() {
	Albedo = texture(gtexture, TextureUV) * GlColor;
    Normal = vec4(VertexNormal / 2.0 + 0.5, 1.0);
    Specular = texture(specular, TextureUV);
    
    if (texture(specular, TextureUV).a < 0.1){ // Fix if just hand mainly
        Specular = vec4(0.0, 0.0, 0.0, 1.0);
    }

	if (Albedo.a < 0.1) {
		discard;
	}
}