#version 430 compatibility

// Uniforms //
uniform float viewHeight;
uniform float viewWidth;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;
uniform vec3 cameraPosition;

// In //
in vec4 StarData; //rgb = star color, a = flag for weather or not this pixel is a star.

// Includes //
#include Utility/Atmosphere.glsl

// Code //
/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 FragColor;

vec3 screenToWorld(vec3 screenPos) {
	vec4 ndcPos = vec4(screenPos, 1.0) * 2.0 - 1.0;
	vec4 tmp = gbufferProjectionInverse * ndcPos;
    tmp.xyz /= tmp.w;
    vec3 pos = mat3(gbufferModelViewInverse) * tmp.xyz;
	return pos;
}

void main() {
	if (StarData.a > 0.5) {
		FragColor = vec4(StarData.rgb, 1.0);
	} else {
		vec3 pos = screenToWorld(vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), 1.0));
		FragColor = vec4(Atmosphere_SampleVanillaSky(RayStr(cameraPosition, normalize(pos), vec3(0), vec3(0))), 1.0);
	}
}