#version 430 compatibility

// Textures //
uniform sampler2D gtexture;
uniform sampler2D lightmap;
uniform sampler2D specular;
uniform sampler2D normals;

// Uniforms //
uniform vec3 cameraPosition;
uniform mat4 gbufferModelViewInverse;
uniform ivec2 atlasSize;

// In //
in vec2 TextureUV;
in vec2 LightMapUV;
in vec4 GlColor;
in mat3 TBN;
flat in int TextureSize;
flat in vec2 BottomCoord;

flat in vec3 VertexNormal;
in vec3 WorldPos;
in vec3 CenterOffset;
in vec3 ViewDir;

// Out //
/* RENDERTARGETS: 0,1,2 */
layout(location = 0) out vec4 OutAlbedo;
layout(location = 1) out vec4 OutNormal;
layout(location = 2) out vec4 OutSpecular;

// Includes // 
#include Utility/Settings.glsl
#include Utility/VoxelMaps.glsl
#include Utility/POM.glsl

// Code //
void main() {
    vec2 ParallaxUV = TextureUV;
    if (length(WorldPos-cameraPosition) < float(POMDistance)) ParallaxUV = GetParallax(TextureUV, normalize(ViewDir*TBN), float(TextureSize)/vec2(atlasSize));
	OutSpecular = texture(specular, ParallaxUV);
    OutAlbedo = texture(gtexture, ParallaxUV) * GlColor;
    vec2 NormalTex = texture(normals, ParallaxUV).xy;
    OutNormal = vec4( normalize( TBN * vec3((NormalTex*2.0-1.0)*NormalMapStrength, sqrt(dot(NormalTex,NormalTex))) ) / 2.0 + 0.5, 1);
    //OutSpecular.a = 1.0;

    if (OutAlbedo.a < 0.1) {
		discard;
	}
}