#version 430 compatibility

// Uniforms //
uniform ivec2 atlasSize;

// In //
in vec4 at_midBlock;
in vec3 mc_Entity;
in vec2 mc_midTexCoord;
in vec4 at_tangent;

// Out //
out vec2 TextureUV;
out vec2 LightMapUV;
out vec4 GlColor;
out mat3 TBN;
flat out int TextureSize;
flat out vec2 BottomCoord;

flat out vec3 VertexNormal;
out vec3 WorldPos;
out vec3 CenterOffset;
out vec3 ViewDir;

// Includes //
#include Utility/Settings.glsl
#include Utility/Voxelize.glsl

// Code //
mat3 CalculateTBN() {
    vec3 bitangent = cross(at_tangent.xyz, gl_Normal);
    return mat3(at_tangent.xyz, bitangent, gl_Normal);
}

uint PackColor(vec3 Color){
    uint Packed = 0;
    ivec3 ColorInt = ivec3(gl_Color.rgb*255.0);
    Packed = Packed | uint(ColorInt.r) << 24;
    Packed = Packed | uint(ColorInt.g) << 16;
    Packed = Packed | uint(ColorInt.b) << 8;
    return Packed;
}

void main() {
	gl_Position = ftransform();
    //gl_Position = gl_ModelViewProjectionMatrix * (gl_Vertex + vec4(at_midBlock.xyz/(64.0*32.0), 0.0)); // Bed and chest issue come from at_midBlock
	TextureUV = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	LightMapUV = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	GlColor = gl_Color;
    VertexNormal = gl_Normal;
    TBN = CalculateTBN();
    ViewDir = mat3(gbufferModelViewInverse) * (gl_ModelViewMatrix*gl_Vertex).xyz;

    int BlockID = int(mc_Entity.x);

    #ifdef Settings_Exclude_Non_Voxels
        if (BlockID % 10 == 0 && BlockID > 0) return;
    #endif

    WorldPos = vec3( ( mat3(gbufferModelViewInverse) * (gl_ModelViewMatrix*gl_Vertex).xyz ) + EyeCameraPosition );
    ivec3 WorldGridPos = ivec3(floor(WorldPos + (at_midBlock.xyz/(64.0*4.0))));
    int StorageID = Voxelize(WorldGridPos);

    // Get UV bounds for texture
    vec2 UVDist = abs(TextureUV - mc_midTexCoord);
    BottomCoord = mc_midTexCoord - UVDist;

    // Store in data buffer
    TextureSize = int(ceil(max(abs(UVDist.x*atlasSize.x), abs(UVDist.y*atlasSize.y))*2.0));
    VoxelTextureData[StorageID] = Voxel(
        ivec3(ivec2(BottomCoord * vec2(atlasSize)), TextureSize),
        PackColor(gl_Color.rgb)
    );
}