#version 430 compatibility

// Textures //
uniform sampler2D gtexture;
uniform sampler2D lightmap;
uniform sampler2D specular;

// Uniforms //
uniform vec3 cameraPosition;
uniform mat4 gbufferModelViewInverse;

// In //
in vec2 TextureUV;
in vec2 LightMapUV;
in vec4 GlColor;

flat in vec3 VertexNormal;
in vec3 WorldPos;
in vec3 CenterOffset;

// Out //
/* DRAWBUFFERS: 012*/
layout(location = 0) out vec4 OutAlbedo;
layout(location = 1) out vec4 OutNormal;
layout(location = 2) out vec4 OutSpecular;

// Includes // 
#include Utility/Settings.glsl
#include Utility/VoxelMaps.glsl

// Code //
float GetDepth(){
    float Depth = 0.25*dot(texture(gtexture, TextureUV).rgb, vec3(0.77, 1.0, 0.68));
    return clamp(1.0-Depth, 0.0, 1.0);
}

void main() {
	OutAlbedo = texture(gtexture, TextureUV) * GlColor;
    OutNormal = vec4(VertexNormal/2.0 + 0.5, 1);
    OutSpecular = texture(specular, TextureUV);

    if (OutAlbedo.a < 0.1) {
		discard;
	}
}