#version 430 compatibility

// Uniforms //
uniform ivec2 atlasSize;

// In //
in vec4 at_midBlock;
in vec3 mc_Entity;
in vec2 mc_midTexCoord;

// Out //
out vec2 TextureUV;
out vec2 LightMapUV;
out vec4 GlColor;

flat out vec3 VertexNormal;
out vec3 WorldPos;
out vec3 CenterOffset;

// Includes //
#include Utility/Settings.glsl
#include Utility/Voxelize.glsl

// Code //
uint PackColor(vec3 Color){
    uint Packed = 0;
    ivec3 ColorInt = ivec3(gl_Color.rgb*255.0);
    Packed = Packed | uint(ColorInt.r) << 24;
    Packed = Packed | uint(ColorInt.g) << 16;
    Packed = Packed | uint(ColorInt.b) << 8;
    return Packed;
}

void main() {
	gl_Position = ftransform();
	TextureUV = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	LightMapUV = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	GlColor = gl_Color;
    VertexNormal = gl_Normal;

    int BlockID = int(mc_Entity.x);

    #ifdef Settings_Exclude_Non_Voxels
        if (BlockID % 10 == 0 && BlockID > 0) return;
    #endif

    WorldPos = vec3( ( mat3(gbufferModelViewInverse) * (gl_ModelViewMatrix*gl_Vertex).xyz ) + EyeCameraPosition );
    ivec3 WorldGridPos = ivec3(floor(WorldPos + (at_midBlock.xyz/(64.0*4.0))));
    int StorageID = Voxelize(WorldGridPos);

    // Get UV bounds for texture
    vec2 UVDist = abs(TextureUV - mc_midTexCoord);
    ivec2 BottomCoord = ivec2((mc_midTexCoord - UVDist) * vec2(atlasSize));

    // Store in data buffer
    VoxelTextureData[StorageID] = Voxel(
        ivec3(BottomCoord, int(ceil(max(abs(UVDist.x*atlasSize.x), abs(UVDist.y*atlasSize.y))*2.0))),
        PackColor(gl_Color.rgb)
    );
}