// Clear Buffers //
#version 430 compatibility

// Textures //
uniform sampler2D colortex0;

// Uniforms //
uniform float viewWidth;
uniform float viewHeight;

// In //
in vec2 TextureUV;

// Out //
out vec4 FragColor;

// Includes //
#include Utility/VoxelMaps.glsl
#include Utility/Settings.glsl

// Constants //
ivec2 ScreenSize = ivec2(viewWidth*RenderScale, viewHeight*RenderScale);

void main(){
    ivec2 Texel = ivec2(TextureUV * vec2(ScreenSize));
    int ID = Texel.x + (Texel.y * ScreenSize.x);

    // Clear Maps //
    // 16,777,216 is the length of LOD0
    const int Iterations = 16777216;
    
    for (int IterID = ID; IterID < Iterations; IterID += int(ScreenSize.x*ScreenSize.y)){
        LOD0[IterID] = 0;
        LOD1[IterID] = 0;
        LOD2[IterID] = 0;
        LOD3[IterID] = 0;
    }
}